/*
 * Decompiled with CFR 0.152.
 */
package comics.gui;

import comics.SCC_MC;
import comics.graph.data.Edge;
import comics.graph.data.Node;
import comics.graph.gui.GraphWrapper;
import comics.gui.GUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ContextMenu
extends JPopupMenu
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JMenuItem contextMenuSetInitial = new JMenuItem("Choose as initial state");
    private JMenuItem contextMenuToggleTarget = new JMenuItem("Toggle target state");
    private JMenuItem contextMenuReduce = new JMenuItem("Reduce");
    private JMenuItem contextMenuExpand = new JMenuItem("Expand");
    private JMenuItem contextChangeProbabilitiy = new JMenuItem("Change probability");
    private boolean isNode;
    private Node node;
    private Edge edge;

    public ContextMenu() {
        this.add(this.contextMenuSetInitial);
        this.add(this.contextMenuToggleTarget);
        this.add(this.contextMenuReduce);
        this.add(this.contextMenuExpand);
        this.add(this.contextChangeProbabilitiy);
        this.contextMenuSetInitial.addActionListener(this);
        this.contextMenuToggleTarget.addActionListener(this);
        this.contextMenuReduce.addActionListener(this);
        this.contextMenuExpand.addActionListener(this);
        this.contextChangeProbabilitiy.addActionListener(this);
    }

    public void show(MouseEvent mouseEvent, Node node) {
        this.isNode = true;
        this.node = node;
        this.show(mouseEvent);
    }

    public void show(MouseEvent mouseEvent, Edge edge) {
        this.isNode = false;
        this.edge = edge;
        this.show(mouseEvent);
    }

    public void show(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = !SCC_MC.getInstance().isGraphLocked();
        if (!this.isNode) {
            this.contextChangeProbabilitiy.setEnabled(bl);
            this.contextMenuSetInitial.setEnabled(false);
            this.contextMenuToggleTarget.setEnabled(false);
            this.contextMenuReduce.setEnabled(false);
            this.contextMenuExpand.setEnabled(false);
        } else {
            this.contextMenuSetInitial.setEnabled(bl);
            this.contextMenuToggleTarget.setEnabled(bl);
            this.contextChangeProbabilitiy.setEnabled(false);
            if (this.node.isInputOfScc()) {
                if (this.node.isReduced()) {
                    this.contextMenuExpand.setEnabled(true);
                    this.contextMenuReduce.setEnabled(false);
                } else {
                    this.contextMenuExpand.setEnabled(false);
                    this.contextMenuReduce.setEnabled(true);
                }
            } else {
                this.contextMenuReduce.setEnabled(false);
                this.contextMenuExpand.setEnabled(false);
            }
        }
        this.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SCC_MC sCC_MC = SCC_MC.getInstance();
        GUI gUI = sCC_MC.getGui();
        GraphWrapper graphWrapper = gUI.wrapper;
        if ("Choose as initial state".equals(actionEvent.getActionCommand())) {
            sCC_MC.chooseInitialNode(this.node);
            gUI.setStatusBarMessage("Choose as initial state");
        }
        if ("Toggle target state".equals(actionEvent.getActionCommand())) {
            sCC_MC.toggleTargetState(this.node);
            gUI.setStatusBarMessage("Chosen as target state");
        }
        if ("Reduce".equals(actionEvent.getActionCommand())) {
            graphWrapper.reduceSCC(this.node);
            gUI.setStatusBarMessage("Reduced");
        }
        if ("Expand".equals(actionEvent.getActionCommand())) {
            graphWrapper.expandSCC(this.node);
            gUI.setStatusBarMessage("Expanded");
        }
        if ("Change probability".equals(actionEvent.getActionCommand())) {
            graphWrapper.changeProbability(this.edge);
        }
        graphWrapper.requestFocusForGraph();
    }
}

