/*
 * Decompiled with CFR 0.152.
 */
package comics.gui.counterexample;

import comics.SCC_MC;
import comics.data.CounterExampleSearchParameters;
import comics.graph.data.MarkovChain;
import comics.gui.GUI;
import comics.gui.counterexample.CounterExampleInitDialog;
import comics.gui.counterexample.CounterExampleStepDialog;
import comics.gui.counterexample.PathResult;
import comics.io.FileHandler;
import comics.io.input.XmlParser;
import comics.io.output.XmlWriter;
import comics.tools.counterexample.SccModelChecker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class ToolbarCounterExample
extends JToolBar
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private GUI gui;
    private JButton buttonModelCheck;
    private JButton buttonCounterExample;
    private SccModelChecker modelChecker = null;
    private boolean initialized;

    public ToolbarCounterExample(GUI gUI) {
        this.gui = gUI;
        this.setFloatable(false);
        this.setRollover(true);
        this.initButtons();
    }

    private void initButtons() {
        this.buttonModelCheck = new JButton("Model Check");
        this.buttonModelCheck.setVerticalTextPosition(0);
        this.buttonModelCheck.setHorizontalTextPosition(10);
        this.buttonModelCheck.setMnemonic(77);
        this.buttonModelCheck.setActionCommand("modelCheck");
        this.buttonModelCheck.addActionListener(this);
        this.add(this.buttonModelCheck);
        this.buttonCounterExample = new JButton("Search Counterexample");
        this.buttonCounterExample.setVerticalTextPosition(0);
        this.buttonCounterExample.setHorizontalTextPosition(10);
        this.buttonCounterExample.setMnemonic(70);
        this.buttonCounterExample.setActionCommand("searchCounterExample");
        this.buttonCounterExample.addActionListener(this);
        this.add(this.buttonCounterExample);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SCC_MC sCC_MC = SCC_MC.getInstance();
        if (actionEvent.getActionCommand().equals("modelCheck")) {
            this.gui.setStatusBarMessage("Model Checking");
            sCC_MC.lockGraph();
            this.modelChecker = new SccModelChecker();
            if (sCC_MC.getMarkovChain().isEmpty()) {
                GUI.showErrorMessage("No Markov Chain specified. Please load a file or create a graph!");
                sCC_MC.unlockGraph();
                return;
            }
            if (!sCC_MC.getMarkovChain().hasInitialAndTarget()) {
                GUI.showErrorMessage("Markov Chain can't be model checked. Initial or target state is missing");
                sCC_MC.unlockGraph();
                return;
            }
            if (!SCC_MC.getInstance().getMarkovChain().isMarkovChainConsistent()) {
                GUI.showErrorMessage("Warning! Markov chain ist not consistent!");
                boolean bl = GUI.showYesNoQuestion("Insert self loops?", "Would you like to insert self loops for absorbing states and continue model checking?");
                if (bl) {
                    SCC_MC.getInstance().getMarkovChain().insertSelfLoops(this.gui);
                } else {
                    this.reset();
                    return;
                }
            }
            sCC_MC.setModelCheckResult(this.modelChecker.modelCheck(sCC_MC.getMarkovChain()));
            if (sCC_MC.getModelCheckResult() == null) {
                GUI.showErrorMessage("No model checking result");
                sCC_MC.unlockGraph();
                return;
            }
            sCC_MC.executeParser(new XmlParser(sCC_MC.getModelCheckResult().getMarkovChain()));
            this.gui.hideAbsorbingNodes(true);
        } else if (actionEvent.getActionCommand().equals("searchCounterExample")) {
            this.gui.setStatusBarMessage("Search counterexample");
            if (!this.initialized && !this.initializeCounterExample()) {
                return;
            }
            if (sCC_MC.counterExampleSearchParameters.isAbstractSearch()) {
                boolean bl = new CounterExampleStepDialog().show(sCC_MC.counterExampleSearchParameters);
                if (!bl) {
                    return;
                }
                sCC_MC.counterExampleSearchParameters.setConcretizedNodes(this.gui.wrapper.getConcretizedGraphs());
            } else {
                sCC_MC.counterExampleSearchParameters.setStepsTillEnd(true);
                sCC_MC.counterExampleSearchParameters.setNoAutoConcretize(false);
            }
            sCC_MC.counterExampleResult = this.modelChecker.doCounterExampleSteps(sCC_MC.counterExampleSearchParameters);
            if (sCC_MC.counterExampleResult == null) {
                GUI.showErrorMessage("No counterexample");
                sCC_MC.unlockGraph();
                return;
            }
            if (sCC_MC.counterExampleResult.getSteps() == 0) {
                GUI.showMessage("Nothing was concretized!", "No User Input!", 1);
            } else {
                this.gui.setStatusBarMessage("Stepsize: " + sCC_MC.counterExampleSearchParameters.getStepSize() + ", Stepcount: " + sCC_MC.counterExampleResult.getSteps());
                if (sCC_MC.counterExampleSearchParameters.isClosure()) {
                    sCC_MC.executeParser(new XmlParser(sCC_MC.counterExampleResult.getMarkovChain()));
                    this.gui.hideAbsorbingNodes(true);
                } else {
                    String string = sCC_MC.counterExampleResult.getMarkovChain();
                    new PathResult().show(string);
                    FileHandler.StringToFileContent(string, new File("counter_example_paths.txt"));
                }
                if (sCC_MC.counterExampleResult.isComplete()) {
                    GUI.showMessage("Counterexample generation finished", "Counterexample complete", 1);
                    sCC_MC.unlockGraph();
                }
            }
        }
    }

    public boolean initializeCounterExample() {
        double d;
        boolean bl;
        CounterExampleSearchParameters counterExampleSearchParameters = SCC_MC.getInstance().counterExampleSearchParameters;
        if (counterExampleSearchParameters == null) {
            counterExampleSearchParameters = new CounterExampleSearchParameters();
        }
        if (!(bl = new CounterExampleInitDialog().show(counterExampleSearchParameters))) {
            return false;
        }
        if (counterExampleSearchParameters.getProbabilityBound() == 0.0) {
            counterExampleSearchParameters.setProbabilityBound(SCC_MC.getInstance().getModelCheckResult().getProbability());
        }
        if ((d = GUI.getProbability("Enter probability for counterexample search", counterExampleSearchParameters.getProbabilityBound())) == 0.0 || d > SCC_MC.getInstance().getModelCheckResult().getProbability()) {
            return false;
        }
        counterExampleSearchParameters.setProbabilityBound(d);
        MarkovChain markovChain = SCC_MC.getInstance().getMarkovChain();
        String string = new XmlWriter(markovChain, false, SCC_MC.getInstance().getModelCheckResult().getProbability()).markovChainToXMLString(markovChain);
        SCC_MC.getInstance().counterExampleSearchParameters = counterExampleSearchParameters;
        this.initialized = this.modelChecker.initCounterExampleSearch(string, counterExampleSearchParameters);
        if (!this.initialized) {
            GUI.showErrorMessage("Could not initialize counterexample module");
            SCC_MC.getInstance().unlockGraph();
            return false;
        }
        this.gui.getOutputPanel().getOverviewPanel().reloadValues();
        return true;
    }

    public void reset() {
        this.buttonModelCheck.setEnabled(true);
        this.buttonCounterExample.setEnabled(false);
        this.initialized = false;
        if (this.modelChecker != null) {
            this.modelChecker.cleanup();
            this.modelChecker = null;
        }
    }

    public void enableCounterExampleSearch() {
        this.buttonModelCheck.setEnabled(false);
        this.buttonCounterExample.setEnabled(true);
        if (this.modelChecker == null) {
            this.modelChecker = new SccModelChecker();
        }
    }
}

