/*
 * Decompiled with CFR 0.152.
 */
package comics.gui.output_panel;

import comics.SCC_MC;
import comics.data.Config;
import comics.graph.data.MarkovChain;
import comics.graph.data.Node;
import comics.gui.output_panel.OutputPanel;
import comics.gui.output_panel.SpringUtilities;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class OverviewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel textNoNodes = new JLabel();
    private JLabel textNoEdges = new JLabel();
    private JLabel textInitial = new JLabel();
    private JLabel textFilename = new JLabel();
    private JLabel textProbabilityModelCheck = new JLabel();
    private JLabel textProbabilityBound = new JLabel();
    private JLabel textProbabilitySubsystem = new JLabel();
    private JLabel textNoSteps = new JLabel();

    public OverviewPanel() {
        super(new SpringLayout());
        this.addRow("Number states", this.textNoNodes);
        this.addRow("Number edges", this.textNoEdges);
        this.addRow("Initial", this.textInitial);
        this.addRow("Filename", this.textFilename);
        this.addRow("Prob. model check", this.textProbabilityModelCheck);
        this.addRow("Prob. bound", this.textProbabilityBound);
        this.addRow("Prob. crit. subsystem", this.textProbabilitySubsystem);
        this.addRow("Number steps", this.textNoSteps);
        SpringUtilities.makeCompactGrid(this, 8, 2, 6, 6, 6, 6);
        this.setDefault();
    }

    private void addRow(String string, JComponent jComponent) {
        JLabel jLabel = new JLabel(string);
        this.add(jLabel);
        jLabel.revalidate();
        jLabel.repaint();
        this.add(jComponent);
    }

    public void setDefault() {
        this.setText(this.textNoNodes, "0");
        this.setText(this.textNoEdges, "0");
        this.setText(this.textInitial, "none");
        this.setText(this.textFilename, "");
        this.setText(this.textProbabilityModelCheck, "0");
        this.setText(this.textProbabilityBound, "0");
        this.setText(this.textProbabilitySubsystem, "0");
        this.setText(this.textNoSteps, "0");
    }

    public void reloadValues() {
        MarkovChain markovChain = SCC_MC.getInstance().getMarkovChain();
        if (markovChain != null) {
            OutputPanel outputPanel = SCC_MC.getInstance().getGui().getOutputPanel();
            int n = outputPanel.getTabNodes().getNodeCount();
            this.setText(this.textNoNodes, "" + n);
            int n2 = outputPanel.getTabEdges().getEdgeCount();
            this.setText(this.textNoEdges, "" + n2);
            if (markovChain.getInitialNode() != null) {
                this.setText(this.textInitial, markovChain.getInitialNode().toString());
            } else {
                String string = "";
                if (!markovChain.getInputNodes().isEmpty()) {
                    for (Node node : markovChain.getInputNodes()) {
                        string = string + node.toString() + ", ";
                    }
                    if ((string = string.substring(0, string.length() - 2)).isEmpty()) {
                        this.setText(this.textInitial, "none");
                    } else {
                        this.setText(this.textInitial, string);
                    }
                }
            }
            this.setText(this.textFilename, Config.filename);
            if (SCC_MC.getInstance().getModelCheckResult() != null) {
                this.setText(this.textProbabilityModelCheck, "" + SCC_MC.getInstance().getModelCheckResult().getProbability());
            } else {
                this.setText(this.textProbabilityModelCheck, "0");
            }
            if (SCC_MC.getInstance().counterExampleResult != null) {
                this.setText(this.textProbabilitySubsystem, "" + SCC_MC.getInstance().counterExampleResult.getProbability());
                this.setText(this.textNoSteps, "" + SCC_MC.getInstance().counterExampleResult.getSteps());
            } else {
                this.setText(this.textProbabilitySubsystem, "0");
                this.setText(this.textNoSteps, "0");
            }
            if (SCC_MC.getInstance().counterExampleSearchParameters != null) {
                this.setText(this.textProbabilityBound, "" + SCC_MC.getInstance().counterExampleSearchParameters.getProbabilityBound());
            } else {
                this.setText(this.textProbabilityBound, "0");
            }
        } else {
            this.setDefault();
        }
    }

    private void setText(JLabel jLabel, String string) {
        jLabel.setText(string);
    }
}

