/*
 * Decompiled with CFR 0.152.
 */
package comics.gui.output_panel;

import comics.SCC_MC;
import comics.graph.data.Node;
import comics.gui.output_panel.OverviewPanel;
import comics.gui.output_panel.SortedListModel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class TabNodes
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private JList list;
    private SortedListModel<Node> listModel;
    private OverviewPanel overviewPanel;

    public TabNodes(OverviewPanel overviewPanel) {
        this.setName("States");
        this.overviewPanel = overviewPanel;
        this.listModel = new SortedListModel();
        this.list = new JList<Node>(this.listModel);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new NodeRenderer());
        this.setViewportView(this.list);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JList jList = (JList)mouseEvent.getSource();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                jList.setSelectedIndex(n);
                Node node = (Node)TabNodes.this.listModel.getElementAt(n);
                if (mouseEvent.getModifiers() == 4) {
                    SCC_MC.getInstance().getGui().wrapper.setSelectedNode(node);
                    SCC_MC.getInstance().getGui().getContextMenu().show(mouseEvent, node);
                }
                if (mouseEvent.getClickCount() == 2) {
                    SCC_MC.getInstance().getGui().wrapper.centerNode(node);
                }
            }
        });
    }

    public void clear() {
        this.listModel.clear();
    }

    public void addNode(Node node) {
        this.listModel.add(node);
        this.overviewPanel.reloadValues();
    }

    public void changeNode(Node node) {
        this.listModel.removeElement(node);
        this.listModel.add(node);
        this.overviewPanel.reloadValues();
    }

    public void removeNode(Node node) {
        this.listModel.removeElement(node);
        this.overviewPanel.reloadValues();
    }

    public int getNodeCount() {
        return this.listModel.getSize();
    }

    private class NodeRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private NodeRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Node node = (Node)object;
            String string = node.toString();
            String string2 = node.propertyString();
            if (!string2.isEmpty()) {
                string = string + " (" + string2 + ")";
            }
            this.setText(string);
            return this;
        }
    }
}

