/*
 * Decompiled with CFR 0.152.
 */
package comics.tools.counterexample;

import comics.SCC_MC;
import comics.data.CounterExampleResult;
import comics.data.CounterExampleSearchParameters;
import comics.data.ModelCheckResult;
import comics.graph.data.InconsistentMarkovChainException;
import comics.graph.data.MarkovChain;
import comics.tools.counterexample.JniMethods;
import comics.utilities.Output;

public class SccModelChecker {
    private JniMethods nativeInterface = new JniMethods();
    private boolean wasModelChecked = false;
    private boolean wasCexInitialized = false;
    private boolean wasCexStarted = false;
    private boolean wasCexCompleted = false;

    public ModelCheckResult modelCheck(MarkovChain markovChain) {
        try {
            String string = markovChain.to_scc_mc_string();
            if (!this.nativeInterface.loadData(string)) {
                return null;
            }
        }
        catch (InconsistentMarkovChainException inconsistentMarkovChainException) {
            return null;
        }
        return this.modelCheck();
    }

    public ModelCheckResult modelCheck(String string) {
        if (!this.nativeInterface.loadFile(string)) {
            return null;
        }
        return this.modelCheck();
    }

    private ModelCheckResult modelCheck() {
        String string = this.nativeInterface.modelCheck();
        double d = 0.0;
        if (string != null && !string.equals("")) {
            d = this.nativeInterface.getResultProbability();
            this.wasModelChecked = true;
            return new ModelCheckResult(string, d);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean initCounterExampleSearch(String string, CounterExampleSearchParameters counterExampleSearchParameters) {
        boolean bl;
        if (!this.wasModelChecked) {
            if (SCC_MC.getInstance().getModelCheckResult() == null) return false;
            if (!(SCC_MC.getInstance().getModelCheckResult().getProbability() > 0.0)) return false;
            this.wasModelChecked = true;
        }
        if (counterExampleSearchParameters.getProbabilityBound() > SCC_MC.getInstance().getModelCheckResult().getProbability()) {
            return false;
        }
        this.wasCexInitialized = bl = this.nativeInterface.initCounterExampleSearch(string, counterExampleSearchParameters.getProbabilityBound(), counterExampleSearchParameters.isAbstractSearch(), counterExampleSearchParameters.isGlobalSearch(), counterExampleSearchParameters.isClosure());
        return this.wasCexInitialized;
    }

    public CounterExampleResult doCounterExampleSteps(CounterExampleSearchParameters counterExampleSearchParameters) {
        if (!this.wasCexStarted && !this.wasCexInitialized) {
            Output.print("Initialization failed -> can't do a thing");
            return null;
        }
        if (this.isCounterExampleComplete()) {
            Output.print("Counterexample already complete -> nothin left to do");
            return null;
        }
        int n = counterExampleSearchParameters.getHeuristic().getNo();
        int n2 = counterExampleSearchParameters.getConcretizationMode().getNo();
        String string = this.nativeInterface.doCounterExampleSteps(counterExampleSearchParameters.getConcretizedNodes(), !counterExampleSearchParameters.isNoAutoConcretize(), counterExampleSearchParameters.isStepsTillEnd(), counterExampleSearchParameters.getStepSize(), n2, n);
        if (string == null) {
            return null;
        }
        CounterExampleResult counterExampleResult = new CounterExampleResult();
        if (string.contains("No step")) {
            counterExampleResult.setSteps(0);
            return counterExampleResult;
        }
        this.wasCexStarted = true;
        counterExampleResult.setMarkovChain(string);
        if (!counterExampleSearchParameters.isAbstractSearch()) {
            this.wasCexCompleted = true;
        }
        counterExampleResult.setComplete(this.isCounterExampleComplete());
        counterExampleResult.setSteps(this.getCounterExampleSteps());
        counterExampleResult.setProbability(this.getCounterExampleProbability());
        return counterExampleResult;
    }

    public boolean isCounterExampleComplete() {
        if (!this.wasCexCompleted) {
            this.wasCexCompleted = this.nativeInterface.isCounterExampleComplete();
        }
        return this.wasCexCompleted;
    }

    public int getCounterExampleSteps() {
        return this.nativeInterface.getCounterExampleSteps();
    }

    public double getCounterExampleProbability() {
        return this.nativeInterface.getCounterExampleProbability();
    }

    public void cleanup() {
        this.nativeInterface.destroy();
        this.nativeInterface = null;
    }
}

