/*
 * Decompiled with CFR 0.152.
 */
package comics.data;

import comics.utilities.Output;

public class CounterExampleSearchParameters {
    private boolean abstractSearch = true;
    private boolean globalSearch = true;
    private boolean closure = true;
    private double probabilityBound = 0.0;
    private boolean noAutoConcretize = false;
    private boolean stepsTillEnd = true;
    private int stepSize = 1;
    private Heuristic heuristic = Heuristic.PROBABILITY;
    private ConcretizationMode concretizationMode = ConcretizationMode.SQRT;
    private int[] concretizedNodes = new int[0];

    public boolean isAbstractSearch() {
        return this.abstractSearch;
    }

    public void setAbstractSearch(boolean bl) {
        this.abstractSearch = bl;
    }

    public boolean isGlobalSearch() {
        return this.globalSearch;
    }

    public void setGlobalSearch(boolean bl) {
        this.globalSearch = bl;
        if (!bl) {
            this.setClosure(true);
        }
    }

    public boolean isClosure() {
        return this.closure;
    }

    public void setClosure(boolean bl) {
        if (!this.isGlobalSearch() && !bl) {
            Output.print("Can not use pathsum with local search. I will ignore this input.");
        } else {
            this.closure = bl;
        }
    }

    public double getProbabilityBound() {
        return this.probabilityBound;
    }

    public void setProbabilityBound(double d) {
        this.probabilityBound = d;
    }

    public boolean isNoAutoConcretize() {
        return this.noAutoConcretize;
    }

    public void setNoAutoConcretize(boolean bl) {
        this.noAutoConcretize = bl;
    }

    public boolean isStepsTillEnd() {
        return this.stepsTillEnd;
    }

    public void setStepsTillEnd(boolean bl) {
        this.stepsTillEnd = bl;
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(int n) {
        this.stepSize = n;
    }

    public Heuristic getHeuristic() {
        return this.heuristic;
    }

    public void setHeuristic(Heuristic heuristic) {
        this.heuristic = heuristic;
    }

    public ConcretizationMode getConcretizationMode() {
        return this.concretizationMode;
    }

    public void setConcretizationMode(ConcretizationMode concretizationMode) {
        this.concretizationMode = concretizationMode;
    }

    public int[] getConcretizedNodes() {
        return this.concretizedNodes;
    }

    public void setConcretizedNodes(int[] nArray) {
        this.concretizedNodes = nArray;
    }

    public static enum ConcretizationMode {
        SQRT("Square root: concretize only square root of all possible", 0),
        ONE("One: concretize only one", 1),
        ALL("All: concretize all", 2);

        private final String name;
        private final int no;

        private ConcretizationMode(String string2, int n2) {
            this.name = string2;
            this.no = n2;
        }

        public String toString() {
            return this.name;
        }

        public int getNo() {
            return this.no;
        }
    }

    public static enum Heuristic {
        NONE("None: do not sort", 0),
        PROBABILITY("Probability: by highest outgoing probability", 2),
        DEGREE("Degree: by lowest input/output degree", 3),
        MEMBERSHIP("Membership: by highest relative membership in subsystem", 4);

        private final String name;
        private final int no;

        private Heuristic(String string2, int n2) {
            this.name = string2;
            this.no = n2;
        }

        public String toString() {
            return this.name;
        }

        public int getNo() {
            return this.no;
        }
    }
}

