/*
 * Decompiled with CFR 0.152.
 */
package comics.graph.data;

import com.mxgraph.model.mxCell;
import comics.graph.data.Edge;
import comics.graph.data.InconsistentMarkovChainException;
import comics.graph.data.Labels;
import comics.graph.data.Node;
import comics.graph.data.ProbabilityExceededException;
import comics.graph.gui.GraphModificationListener;
import comics.graph.gui.GraphWrapper;
import comics.gui.GUI;
import comics.utilities.Output;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.TreeSet;

public class MarkovChain
implements Comparable<MarkovChain>,
Serializable,
GraphModificationListener {
    private static final long serialVersionUID = 1L;
    private int maxNodeNo = 0;
    private int id;
    private int recursionDepth = 0;
    private boolean isReduced;
    private boolean expandedInGraph;
    private MarkovChain parent;
    private TreeSet<Node> nodes = new TreeSet();
    private TreeSet<Edge> edges = new TreeSet();
    private TreeSet<Node> targetNodes;
    private Node initialNode = null;
    private TreeSet<Node> inputNodes = new TreeSet();
    private TreeSet<MarkovChain> subgraphs;
    private TreeSet<Edge> reducedEdges = null;
    private Labels labels;

    public MarkovChain() {
        this.targetNodes = new TreeSet();
        this.subgraphs = new TreeSet();
        this.labels = new Labels();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public int getRecursionDepth() {
        return this.recursionDepth;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public void setParent(MarkovChain markovChain) {
        this.parent = markovChain;
        this.recursionDepth = markovChain.getRecursionDepth() + 1;
    }

    public MarkovChain getParent() {
        return this.parent;
    }

    public boolean isReduced() {
        return this.isReduced;
    }

    public void setReduced(boolean bl) {
        this.isReduced = bl;
        if (bl && this.reducedEdges == null) {
            this.reducedEdges = new TreeSet();
        }
    }

    public void setExpandedInGraph(boolean bl) {
        this.expandedInGraph = bl;
    }

    public boolean isExpandedInGraph() {
        return this.expandedInGraph;
    }

    public void addLabel(String string) {
        this.labels.add(string);
    }

    public Labels getLabels() {
        return this.labels;
    }

    public Labels getLabelsNode(Node node) {
        return node.getLabels();
    }

    public void createAllNodesTil(int n) {
        while (this.maxNodeNo < n) {
            this.addNode();
        }
    }

    public Node addNode() {
        return this.addNode(this.maxNodeNo + 1);
    }

    public Node addNode(int n) {
        Node node = new Node(n);
        this.nodes.add(node);
        if (this.getMaxNodeNo() < n) {
            this.maxNodeNo = n;
        }
        node.setCorrespondingMarkovChain(this);
        return node;
    }

    public void removeNode(Node node) {
        if (node == null) {
            return;
        }
        this.deleteConnections(node);
        this.nodes.remove(node);
        if (node.isInitial()) {
            this.setInitialNode(null);
        }
        if (node.isInputOfScc()) {
            this.inputNodes.remove(node);
        }
        if (node.isTarget()) {
            this.targetNodes.remove(node);
        }
    }

    private void deleteConnections(Node node) {
        for (Edge edge : this.getConnections(node)) {
            this.removeEdge(edge);
        }
    }

    public Edge addEdge(Node node, Node node2, double d) throws ProbabilityExceededException {
        return this.addEdge(node, node2, d, false);
    }

    public Edge addEdge(Node node, Node node2, double d, boolean bl) throws ProbabilityExceededException {
        Edge edge = new Edge(node, node2, d, bl);
        this.addEdge(edge);
        return edge;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addEdge(Edge edge) throws ProbabilityExceededException {
        boolean bl = false;
        if (!edge.isReduced()) {
            if (this.edges.contains(edge)) {
                Edge edge2 = this.edges.floor(edge);
                double d = edge2.getProbability() + edge.getProbability();
                if (!MarkovChain.isConsistent(d)) throw new ProbabilityExceededException("" + d);
                edge2.setProbability(d);
                bl = true;
            } else {
                this.edges.add(edge);
                edge.getSourceNode().getAdjacentNodes().add(edge.getTargetNode());
                edge.getTargetNode().getAdjacentToNodes().add(edge.getSourceNode());
            }
            edge.getSourceNode().setOutgoingProbability(edge.getProbability() + edge.getSourceNode().getOutgoingProbability());
            return bl;
        } else {
            this.reducedEdges.add(edge);
            edge.getSourceNode().getAdjacentNodes().add(edge.getTargetNode());
            edge.getTargetNode().getAdjacentToNodes().add(edge.getSourceNode());
        }
        return bl;
    }

    public void removeEdge(Edge edge) {
        if (edge == null) {
            return;
        }
        edge.getSourceNode().getAdjacentNodes().remove(edge.getTargetNode());
        double d = edge.getSourceNode().getOutgoingProbability();
        edge.getSourceNode().setOutgoingProbability(d - edge.getProbability());
        edge.getTargetNode().getAdjacentToNodes().remove(edge.getSourceNode());
        if (edge.isReduced()) {
            this.reducedEdges.remove(edge);
        } else {
            this.edges.remove(edge);
        }
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public int getNumberOfEdges() {
        return this.edges.size();
    }

    public int getMaxNodeNo() {
        return this.maxNodeNo;
    }

    public int getNumberOfReducedEdges() {
        return this.reducedEdges.size();
    }

    public TreeSet<Node> getNodes() {
        return this.nodes;
    }

    public TreeSet<Edge> getEdges() {
        return this.edges;
    }

    public TreeSet<Edge> getReducedEdges() {
        if (this.isReduced) {
            return this.reducedEdges;
        }
        return null;
    }

    public TreeSet<Node> getTargetNodes() {
        return this.targetNodes;
    }

    public TreeSet<Node> getInputNodes() {
        return this.inputNodes;
    }

    public TreeSet<Edge> getConnections(Node node) {
        TreeSet<Edge> treeSet = new TreeSet<Edge>();
        for (Edge edge : treeSet) {
            if (!edge.getSourceNode().equals(node) && !edge.getTargetNode().equals(node)) continue;
            treeSet.add(edge);
        }
        return treeSet;
    }

    public TreeSet<Edge> getOutgoingEdges(Node node) {
        TreeSet<Edge> treeSet = new TreeSet<Edge>();
        for (Edge edge : treeSet) {
            if (!edge.getSourceNode().equals(node)) continue;
            treeSet.add(edge);
        }
        return treeSet;
    }

    public TreeSet<Edge> getIngoingEdges(Node node) {
        TreeSet<Edge> treeSet = new TreeSet<Edge>();
        for (Edge edge : treeSet) {
            if (!edge.getTargetNode().equals(node)) continue;
            treeSet.add(edge);
        }
        return treeSet;
    }

    public Node getInitialNode() {
        return this.initialNode;
    }

    public void setInitialNode(Node node) {
        if (this.initialNode != null) {
            this.initialNode.setInitial(false);
        }
        this.initialNode = node;
        if (this.initialNode != null) {
            this.initialNode.setInitial(true);
        }
    }

    public void setInputOfSccNode(Node node) {
        this.setInputOfSccNode(node, true);
    }

    public void setInputOfSccNode(Node node, boolean bl) {
        if (bl) {
            node.setInputOfScc(true);
            this.inputNodes.add(node);
        } else {
            node.setInputOfScc(false);
            this.inputNodes.remove(node);
        }
    }

    public void setOutputOfSccNode(Node node) {
        this.setOutputOfSccNode(node, true);
    }

    public void setOutputOfSccNode(Node node, boolean bl) {
        if (bl) {
            node.setOutputOfScc(true);
            this.targetNodes.add(node);
        } else {
            node.setOutputOfScc(false);
            this.targetNodes.remove(node);
        }
    }

    public void setReducedNode(Node node, boolean bl) {
        if (bl && !this.isReduced) {
            Output.print("Markov Chain is not reduced!");
            return;
        }
        node.setReduced(bl);
    }

    public void setTargetNode(Node node) {
        this.targetNodes.add(node);
        node.setTarget(true);
    }

    public void setTargetNode(Node node, boolean bl) {
        if (bl) {
            this.setTargetNode(node);
        } else {
            this.targetNodes.remove(node);
            node.setTarget(false);
        }
    }

    public void setNormalNode(Node node) {
        this.setOutputOfSccNode(node, false);
        this.setInputOfSccNode(node, false);
        this.setTargetNode(node, false);
        this.nodes.add(node);
    }

    public void setCorrespondingMarkovChainNode(Node node) {
        node.setCorrespondingMarkovChain(this);
    }

    public void addLabelNode(Node node, String string) {
        if (this.labels.contains(string)) {
            node.addLabel(string);
        }
    }

    public void setProbabilityEdge(Edge edge, double d) throws ProbabilityExceededException {
        if (!MarkovChain.isConsistent(d)) {
            throw new ProbabilityExceededException(edge.toTraString());
        }
        double d2 = edge.getSourceNode().getOutgoingProbability() - edge.getProbability();
        edge.getSourceNode().setOutgoingProbability(d2 + d);
        edge.setProbability(d);
    }

    public boolean containsNode(int n) {
        Node node = new Node(n);
        return this.nodes.contains(node);
    }

    public Node getNodeByIntName(int n) {
        Node node = new Node(n);
        Node node2 = this.nodes.floor(node);
        if (node.equals(node2)) {
            return node2;
        }
        assert (false);
        return null;
    }

    public Edge getEdgeByNodes(Node node, Node node2) {
        for (Edge edge : this.edges) {
            if (!edge.getSourceNode().equals(node) || !edge.getTargetNode().equals(node2)) continue;
            return edge;
        }
        assert (false);
        return null;
    }

    public boolean containsNode(Node node) {
        return this.nodes.contains(node);
    }

    public TreeSet<MarkovChain> getSubgraphs() {
        return this.subgraphs;
    }

    public void addSubgraph(MarkovChain markovChain) {
        this.subgraphs.add(markovChain);
        markovChain.setParent(this);
    }

    public String to_scc_mc_string() throws InconsistentMarkovChainException {
        String string = Output.getLineBreak();
        String string2 = "";
        try {
            string2 = string2 + "STATES " + this.getMaxNodeNo() + string;
            string2 = string2 + "TRANSITIONS " + this.getNumberOfEdges() + string;
            string2 = string2 + "INITIAL " + this.getInitialNode().getNumber() + string;
            for (Node comparable : this.getTargetNodes()) {
                string2 = string2 + "TARGET " + comparable.getNumber() + string;
            }
            for (Edge edge : this.getEdges()) {
                string2 = string2 + edge.getSourceNode().getNumber() + " " + edge.getTargetNode().getNumber() + " " + edge.getProbability() + string;
            }
        }
        catch (Exception exception) {
            throw new InconsistentMarkovChainException("Markov chain in incomplete state.");
        }
        return string2;
    }

    public String to_mrmc_string() {
        String string = Output.getLineBreak();
        String string2 = "";
        string2 = string2 + "STATES " + this.getMaxNodeNo() + string;
        string2 = string2 + "TRANSITIONS " + this.getNumberOfEdges() + string;
        for (Edge edge : this.getEdges()) {
            string2 = string2 + edge.getSourceNode().getNumber() + " " + edge.getTargetNode().getNumber() + " " + edge.getProbability() + string;
        }
        return string2;
    }

    public String toString() {
        String string = Output.getLineBreak();
        StringBuffer stringBuffer = new StringBuffer("------");
        stringBuffer.append(string + "DTMC" + string);
        if (this.isReduced) {
            stringBuffer.append("Reduced; Recursion depth: " + this.recursionDepth + string + string);
        }
        stringBuffer.append("Nodes: ");
        for (Node object : this.getNodes()) {
            stringBuffer.append(object.getNumber() + ", ");
        }
        stringBuffer.append(string);
        stringBuffer.append("Edges: ");
        for (Edge edge : this.getEdges()) {
            stringBuffer.append(string + edge.toString());
        }
        stringBuffer.append(string + "Initial Node/Input Node(s): ");
        if (this.inputNodes.size() > 0) {
            for (Node node : this.getInputNodes()) {
                stringBuffer.append(node.getNumber() + ", ");
            }
        } else if (this.getInitialNode() != null) {
            stringBuffer.append(this.getInitialNode().getNumber() + ", ");
        }
        stringBuffer.append(string + "Target Nodes: ");
        if (this.getTargetNodes().size() > 0) {
            for (Node node : this.getTargetNodes()) {
                stringBuffer.append(node.getNumber() + ", ");
            }
        }
        if (this.subgraphs.size() > 0) {
            stringBuffer.append(string + "Subgraphs:" + string);
            int n = 1;
            for (MarkovChain markovChain : this.getSubgraphs()) {
                stringBuffer.append("Subgraph #" + n + string);
                stringBuffer.append(markovChain.toString());
            }
        }
        stringBuffer.append(string + "(end DTMC)" + string);
        stringBuffer.append(string + "------" + string);
        return stringBuffer.toString();
    }

    public String testOutput(String string) {
        String string2 = Output.getLineBreak();
        StringBuffer stringBuffer = new StringBuffer(string + "------");
        stringBuffer.append(string2 + string + "Markov Chain" + string2);
        stringBuffer.append(string + "Id: " + this.id + string2);
        if (this.isReduced) {
            stringBuffer.append(string + "Reduced; Recursion depth: " + this.recursionDepth + string2 + string2);
        }
        stringBuffer.append(string + "Nodes: ");
        for (Node object : this.getNodes()) {
            stringBuffer.append(object.getNumber() + ", ");
        }
        stringBuffer.append(string2);
        stringBuffer.append(string + "Edges: ");
        for (Edge edge : this.getEdges()) {
            stringBuffer.append(string2 + string + edge.toPropertyString());
        }
        stringBuffer.append(string2 + string + "Reduced Edges: ");
        if (this.getReducedEdges() != null) {
            for (Edge edge : this.getReducedEdges()) {
                stringBuffer.append(string2 + string + edge.toPropertyString());
            }
        }
        stringBuffer.append(string2 + string + "Initial Node(s): ");
        if (this.inputNodes.size() > 0) {
            for (Node node : this.getInputNodes()) {
                stringBuffer.append(node.getNumber() + ", ");
            }
        } else if (this.getInitialNode() != null) {
            stringBuffer.append(this.getInitialNode().getNumber() + ", ");
        }
        stringBuffer.append(string2 + string + "Target Nodes: ");
        if (this.getTargetNodes().size() > 0) {
            for (Node node : this.getTargetNodes()) {
                stringBuffer.append(node.getNumber() + ", ");
            }
        }
        if (this.subgraphs.size() > 0) {
            stringBuffer.append(string2 + string + "Subgraphs:" + this.getSubgraphs().size());
            int n = 1;
            for (MarkovChain markovChain : this.getSubgraphs()) {
                stringBuffer.append(string2 + string + "Subgraph #" + n + string2);
                ++n;
                stringBuffer.append(markovChain.testOutput(string + "  "));
                stringBuffer.append(string2 + string + "(end Subgraph)");
            }
        }
        stringBuffer.append(string2 + string + "(end DTMC)" + string2);
        stringBuffer.append(string2 + string + "------" + string2);
        return stringBuffer.toString();
    }

    public Edge getSecondEdge(Edge edge, boolean bl) {
        for (Edge edge2 : this.edges) {
            if (bl & edge2.equals(edge)) {
                return edge2;
            }
            if (!edge2.getSourceNode().equals(edge.getTargetNode()) || !edge2.getTargetNode().equals(edge.getSourceNode())) continue;
            return edge2;
        }
        return null;
    }

    public void insertSelfLoops(GUI gUI) {
        for (Node node : this.getNodes()) {
            if (node.isConsistent()) continue;
            double d = 1.0 - node.getOutgoingProbability();
            Edge edge = this.getEdgeByNodes(node, node);
            if (edge != null) {
                edge.setProbability(d + edge.getProbability());
                node.setOutgoingProbability(1.0);
                gUI.wrapper.updateDisplayedGraph();
                gUI.getOutputPanel().getTabEdges().changeEdge(edge);
                continue;
            }
            try {
                edge = this.addEdge(node, node, d);
            }
            catch (ProbabilityExceededException probabilityExceededException) {
                // empty catch block
            }
            gUI.wrapper.addEdgeToGraph(edge);
        }
    }

    public void transformToOneTarget(GraphWrapper graphWrapper) {
        if (this.getTargetNodes().size() > 1) {
            Node node = this.addNode();
            graphWrapper.addNodeToGraph(node);
            for (Node node2 : this.getTargetNodes()) {
                node2.setTarget(false);
                Edge edge = null;
                try {
                    edge = this.addEdge(node2, node, 1.0);
                }
                catch (ProbabilityExceededException probabilityExceededException) {
                    // empty catch block
                }
                graphWrapper.addEdgeToGraph(edge);
            }
            this.getTargetNodes().clear();
            this.setTargetNode(node);
            graphWrapper.updateDisplayedGraph();
        }
    }

    public void setTargetLabel(String string) {
        while (!this.getTargetNodes().isEmpty()) {
            this.setTargetNode(this.getTargetNodes().first(), false);
        }
        for (Node node : this.getNodes()) {
            if (!node.getLabels().contains(string)) continue;
            this.setTargetNode(node);
        }
    }

    public ArrayList<Node> getNodesForLabel(String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.getNodes()) {
            if (!node.getLabels().contains(string)) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public boolean isMarkovChainConsistent() {
        for (Node node : this.getNodes()) {
            if (node.isConsistent()) continue;
            return false;
        }
        return true;
    }

    public boolean checkConsistency(Node node) throws ProbabilityExceededException, InconsistentMarkovChainException {
        for (Edge edge : this.edges) {
            if (MarkovChain.isConsistent(edge.getProbability())) continue;
            throw new ProbabilityExceededException(edge.toTraString());
        }
        if (!node.isConsistent()) {
            throw new InconsistentMarkovChainException("Node " + node.toString() + ": " + node.getOutgoingProbability());
        }
        return true;
    }

    public static boolean isConsistent(double d) {
        return !(d < 0.0) && !(d > 1.0);
    }

    public boolean hasInitialAndTarget() {
        if (this.isReduced ? this.getInputNodes().isEmpty() : this.getInitialNode() == null) {
            return false;
        }
        return !this.getTargetNodes().isEmpty();
    }

    @Override
    public void nodeAdded(mxCell mxCell2) {
        Node node = this.addNode();
        mxCell2.setValue(node);
        node.setGraphCell(mxCell2);
    }

    @Override
    public void nodeRemoved(mxCell mxCell2) {
        this.removeNode((Node)mxCell2.getValue());
    }

    @Override
    public boolean edgeAdded(mxCell mxCell2) {
        Node node = (Node)mxCell2.getSource().getValue();
        Node node2 = (Node)mxCell2.getTarget().getValue();
        if (node == null || node2 == null) {
            Output.print("Error: One of the edge terminals is null");
        }
        Edge edge = new Edge(node, node2, 0.0);
        boolean bl = false;
        boolean bl2 = false;
        while (!bl2) {
            try {
                edge.setProbability(GUI.getProbability("Enter probability for edge", 1.0));
                bl = this.addEdge(edge);
                bl2 = true;
            }
            catch (ProbabilityExceededException probabilityExceededException) {
                GUI.showErrorMessage("Probability can't be greater than 1");
            }
        }
        if (!bl) {
            edge.setGraphCell(mxCell2);
        }
        mxCell2.setValue(edge);
        return bl;
    }

    @Override
    public void edgeRemoved(mxCell mxCell2) {
        this.removeEdge((Edge)mxCell2.getValue());
    }

    @Override
    public int compareTo(MarkovChain markovChain) {
        return Math.abs(this.getId()) - Math.abs(markovChain.getId());
    }
}

