/*
 * Decompiled with CFR 0.152.
 */
package comics.graph.gui;

import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.mxCircleLayout;
import com.mxgraph.layout.mxCompactTreeLayout;
import com.mxgraph.layout.mxFastOrganicLayout;
import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.layout.mxIGraphLayout;
import com.mxgraph.layout.mxParallelEdgeLayout;
import com.mxgraph.layout.mxPartitionLayout;
import com.mxgraph.layout.mxStackLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.swing.handler.mxGraphHandler;
import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEvent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUndoManager;
import com.mxgraph.util.mxUndoableEdit;
import com.mxgraph.view.mxGraphView;
import com.mxgraph.view.mxLayoutManager;
import com.mxgraph.view.mxStylesheet;
import comics.SCC_MC;
import comics.data.Config;
import comics.graph.data.Edge;
import comics.graph.data.MarkovChain;
import comics.graph.data.Node;
import comics.graph.data.ProbabilityExceededException;
import comics.graph.gui.CustomGraph;
import comics.graph.gui.GraphModificationListener;
import comics.gui.EditMode;
import comics.gui.GUI;
import comics.gui.actions.GraphMouseListener;
import comics.gui.output_panel.OutputPanel;
import comics.utilities.Output;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;

public class GraphWrapper {
    public static final int GM_VERTEX_ADDED = 0;
    public static final int GM_VERTEX_REMOVED = 1;
    public static final int GM_EDGE_ADDED = 2;
    public static final int GM_EDGE_REMOVED = 3;
    public static final String STYLE_DEFAULT_NODE = "DEFAULT_NODE";
    public static final String STYLE_TARGET_NODE = "TARGET_NODE";
    public static final String STYLE_INITIAL_NODE = "INITIAL_NODE";
    public static final String STYLE_INITIAL_TARGET_NODE = "INITIAL_TARGET_NODE";
    public static final String STYLE_REDUCED_NODE = "REDUCED_NODE";
    public static final String STYLE_SUBGRAPH_NODE = "SUBGRAPH_NODE";
    public static final String STYLE_SUBGRAPH = "SUBGRAPH";
    public static final String STYLE_DEFAULT_EDGE = "DEFAULT_EDGE";
    public static final String STYLE_REDUCED_EDGE = "REDUCED_EDGE";
    public Color defaultNodeColor = Color.BLUE;
    public Color initialNodeColor = Color.GREEN;
    public Color targetNodeColor = Color.RED;
    public Color reducedNodeColor = Color.MAGENTA;
    public Color subgraphNodeColor = Color.YELLOW;
    private Color rubberbandColor = new Color(0.0f, 0.0f, 1.0f, 0.2f);
    private boolean cellsMovable;
    private boolean otherLayoutBefore;
    private CustomGraph graph;
    private OutputPanel outputPanel;
    protected mxUndoManager undoManager = new mxUndoManager();
    private mxGraphComponent graphComponent = null;
    private GraphMouseListener listener;
    private MarkovChain markovChain;
    private ArrayList<GraphModificationListener> modificationListeners = new ArrayList();
    private EditMode editMode;
    private mxLayoutManager layoutManager = new mxLayoutManager(this.graph);

    public GraphWrapper(OutputPanel outputPanel) {
        this.outputPanel = outputPanel;
        this.graph = new CustomGraph();
        this.editMode = EditMode.NONE;
        this.graphComponent = new mxGraphComponent(this.graph);
        this.graphComponent.setToolTips(true);
        this.graphComponent.getViewport().setBackground(Color.WHITE);
        this.initGraph();
        mxEventSource.mxIEventListener mxIEventListener2 = new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object object, mxEventObject mxEventObject2) {
                Output.print("woohoo, an edge, we have!");
                mxCell mxCell2 = (mxCell)mxEventObject2.getProperty("cell");
                if (mxCell2.isEdge()) {
                    mxCell2.setStyle(GraphWrapper.STYLE_DEFAULT_EDGE);
                    GraphWrapper.this.fireGraphModification(2, mxCell2);
                }
            }
        };
        this.graphComponent.getConnectionHandler().addListener("connect", mxIEventListener2);
        this.listener = new GraphMouseListener();
        mxGraphComponent.mxGraphControl mxGraphControl2 = this.graphComponent.getGraphControl();
        mxGraphControl2.addMouseListener(this.listener);
        mxGraphControl2.addMouseWheelListener(this.listener);
    }

    private void initGraph() {
        this.registerStyles();
        mxEventSource.mxIEventListener mxIEventListener2 = new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object object, mxEventObject mxEventObject2) {
                Object[] objectArray;
                for (Object object2 : objectArray = (Object[])mxEventObject2.getProperty("cells")) {
                    mxCell mxCell2 = (mxCell)object2;
                    if (mxCell2.isEdge()) {
                        GraphWrapper.this.fireGraphModification(3, mxCell2);
                        continue;
                    }
                    GraphWrapper.this.fireGraphModification(1, mxCell2);
                }
            }
        };
        this.graph.addListener("cellsRemoved", mxIEventListener2);
        mxRubberband mxRubberband2 = new mxRubberband(this.graphComponent);
        mxRubberband2.setFillColor(this.rubberbandColor);
        mxEventSource.mxIEventListener mxIEventListener3 = new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object object, mxEventObject mxEventObject2) {
                GraphWrapper.this.updateDisplayedGraph();
            }
        };
        this.graph.getSelectionModel().addListener("change", mxIEventListener3);
        mxEventSource.mxIEventListener mxIEventListener4 = new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object object, mxEventObject mxEventObject2) {
                GraphWrapper.this.updateDisplayedGraph();
            }
        };
        this.graph.addListener("moveCells", mxIEventListener4);
        this.layoutManager.destroy();
        this.layoutManager = new mxLayoutManager(this.graph){
            mxGraphLayout layout;
            {
                this.layout = new mxParallelEdgeLayout(this.graph);
            }

            @Override
            public mxIGraphLayout getLayout(Object object) {
                if (this.graph.getModel().getChildCount(object) > 0) {
                    GraphWrapper.this.cellsMovable = this.graph.isCellsMovable();
                    this.graph.setCellsMovable(true);
                    if (GraphWrapper.this.otherLayoutBefore) {
                        for (Edge edge : GraphWrapper.this.markovChain.getEdges()) {
                            if (edge.getGraphCell() == null) continue;
                            edge.getGraphCell().getGeometry().setPoints(null);
                        }
                    }
                    GraphWrapper.this.otherLayoutBefore = false;
                    return this.layout;
                }
                return null;
            }
        };
        mxEventSource.mxIEventListener mxIEventListener5 = new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object object, mxEventObject mxEventObject2) {
                GraphWrapper.this.graph.setCellsMovable(GraphWrapper.this.cellsMovable);
            }
        };
        this.layoutManager.addListener(mxEvent.LAYOUT_CELLS, mxIEventListener5);
        this.otherLayoutBefore = true;
    }

    private void fireGraphModification(int n, mxCell mxCell2) {
        for (GraphModificationListener graphModificationListener : this.modificationListeners) {
            switch (n) {
                case 0: {
                    Output.print("GRAPH MODIFICATION: STATE ADDED");
                    graphModificationListener.nodeAdded(mxCell2);
                    Node node = (Node)mxCell2.getValue();
                    if (this.markovChain.getInitialNode() == null) {
                        this.markovChain.setInitialNode(node);
                    }
                    this.outputPanel.getTabNodes().addNode(node);
                    break;
                }
                case 1: {
                    Output.print("GRAPH MODIFICATION: STATE REMOVED");
                    Node node = (Node)mxCell2.getValue();
                    graphModificationListener.nodeRemoved(mxCell2);
                    this.outputPanel.getTabNodes().removeNode(node);
                    break;
                }
                case 2: {
                    Output.print("GRAPH MODIFICATION: EDGE ADDED");
                    boolean bl = graphModificationListener.edgeAdded(mxCell2);
                    Edge edge = (Edge)mxCell2.getValue();
                    edge.setGraphCell(mxCell2);
                    if (edge.getProbability() == 0.0 || bl) {
                        if (!bl) {
                            this.markovChain.edgeRemoved(mxCell2);
                        }
                        this.alignSecondEdge(edge);
                        mxCell2.removeFromParent();
                        this.setLayout(LayoutType.PARALLEL_EDGE);
                    }
                    if (edge.getProbability() == 0.0) break;
                    if (!bl) {
                        this.outputPanel.getTabEdges().addEdge(edge);
                        break;
                    }
                    this.outputPanel.getTabEdges().changeEdge(this.markovChain.getSecondEdge(edge, true));
                    break;
                }
                case 3: {
                    Output.print("GRAPH MODIFICATION: EDGE REMOVED");
                    graphModificationListener.edgeRemoved(mxCell2);
                    Edge edge = (Edge)mxCell2.getValue();
                    this.alignSecondEdge(edge);
                    this.outputPanel.getTabEdges().removeEdge(edge);
                }
            }
        }
        this.updateDisplayedGraph();
    }

    private void alignSecondEdge(Edge edge) {
        this.otherLayoutBefore = true;
        Edge edge2 = this.markovChain.getSecondEdge(edge, true);
        Edge edge3 = this.markovChain.getSecondEdge(edge, false);
        if (edge2 != null) {
            if (edge3 != null) {
                edge2.getGraphCell().getGeometry().setPoints(null);
                edge3.getGraphCell().getGeometry().setPoints(null);
            } else {
                edge2.getGraphCell().getGeometry().setPoints(null);
            }
        }
    }

    public void setEditMode(EditMode editMode) {
        this.editMode = editMode;
        switch (editMode) {
            case NONE: {
                this.setCursor(Cursor.getPredefinedCursor(13));
                break;
            }
            case ADD_EDGE: {
                this.setCursor(Cursor.getPredefinedCursor(1));
                break;
            }
            case ADD_NODE: {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public EditMode getEditMode() {
        return this.editMode;
    }

    private void initializeUndoHandling() {
        mxEventSource.mxIEventListener mxIEventListener2 = new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object object, mxEventObject mxEventObject2) {
                GraphWrapper.this.undoManager.undoableEditHappened((mxUndoableEdit)mxEventObject2.getProperty("edit"));
                Output.print("register undo event");
            }
        };
        this.graph.getModel().addListener("undo", mxIEventListener2);
        this.graph.getView().addListener("undo", mxIEventListener2);
        mxIEventListener2 = new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object object, mxEventObject mxEventObject2) {
                Output.print("execute undo event");
                List<mxUndoableEdit.mxUndoableChange> list = ((mxUndoableEdit)mxEventObject2.getProperty("edit")).getChanges();
                GraphWrapper.this.graph.setSelectionCells(GraphWrapper.this.graph.getSelectionCellsForChanges(list));
                mxUndoableEdit mxUndoableEdit2 = (mxUndoableEdit)mxEventObject2.getProperty("edit");
                Output.print("Undoable change:");
                for (mxUndoableEdit.mxUndoableChange mxUndoableChange2 : mxUndoableEdit2.getChanges()) {
                    Output.print("* " + mxUndoableChange2.toString());
                    if (!(mxUndoableChange2 instanceof mxGraphModel.mxChildChange)) continue;
                    mxGraphModel.mxChildChange mxChildChange2 = (mxGraphModel.mxChildChange)mxUndoableChange2;
                    mxCell mxCell2 = (mxCell)mxChildChange2.getChild();
                    if (mxCell2.isVertex()) {
                        Output.print("Node change: " + ((Node)mxCell2.getValue()).getNumber());
                        continue;
                    }
                    Output.print("Edge change: " + ((Edge)mxCell2.getValue()).toString());
                }
            }
        };
        this.undoManager.addListener("undo", mxIEventListener2);
        this.undoManager.addListener("redo", mxIEventListener2);
        mxEventSource.mxIEventListener mxIEventListener3 = new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object object, mxEventObject mxEventObject2) {
            }
        };
        this.graph.addListener("addCells", mxIEventListener3);
        this.graph.getModel().addListener("addCells", mxIEventListener3);
        mxEventSource.mxIEventListener mxIEventListener4 = new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object object, mxEventObject mxEventObject2) {
                Output.print("The following cells were removed: ");
                for (Object object2 : (Object[])mxEventObject2.getProperty("cells")) {
                    mxCell mxCell2 = (mxCell)object2;
                    Output.print("* " + GraphWrapper.cellToString(mxCell2));
                }
            }
        };
        this.graph.addListener("removeCells", mxIEventListener4);
        this.graph.getModel().addListener("removeCells", mxIEventListener4);
    }

    private void registerStyles() {
        mxStylesheet mxStylesheet2 = this.graph.getStylesheet();
        Hashtable<String, Object> hashtable = this.getBasicNodeStyle("ellipse", this.defaultNodeColor);
        mxStylesheet2.putCellStyle(STYLE_DEFAULT_NODE, hashtable);
        hashtable = this.getBasicNodeStyle("rhombus", this.initialNodeColor);
        mxStylesheet2.putCellStyle(STYLE_INITIAL_NODE, hashtable);
        hashtable = this.getBasicNodeStyle("doubleEllipse", this.targetNodeColor);
        hashtable.put(mxConstants.STYLE_STROKECOLOR, "black");
        hashtable.put(mxConstants.STYLE_STROKEWIDTH, 2);
        mxStylesheet2.putCellStyle(STYLE_TARGET_NODE, hashtable);
        Color color = this.mixColor(this.initialNodeColor, this.targetNodeColor);
        hashtable = this.getBasicNodeStyle("hexagon", color);
        mxStylesheet2.putCellStyle(STYLE_INITIAL_TARGET_NODE, hashtable);
        hashtable = this.getBasicNodeStyle("rectangle", this.reducedNodeColor);
        mxStylesheet2.putCellStyle(STYLE_REDUCED_NODE, hashtable);
        hashtable = this.getBasicNodeStyle("rectangle", this.subgraphNodeColor);
        mxStylesheet2.putCellStyle(STYLE_SUBGRAPH_NODE, hashtable);
        hashtable = this.getBasicNodeStyle("rectangle", Color.LIGHT_GRAY);
        hashtable.put(mxConstants.STYLE_OPACITY, 95);
        mxStylesheet2.putCellStyle(STYLE_SUBGRAPH, hashtable);
        hashtable = new Hashtable();
        hashtable.put(mxConstants.STYLE_ENDARROW, "classic");
        hashtable.put(mxConstants.STYLE_BENDABLE, "1");
        hashtable.put(mxConstants.STYLE_ROUNDED, "1");
        hashtable.put(mxConstants.STYLE_STROKEWIDTH, "2");
        mxStylesheet2.putCellStyle(STYLE_DEFAULT_EDGE, hashtable);
        hashtable = new Hashtable();
        hashtable.put(mxConstants.STYLE_ENDARROW, "classic");
        hashtable.put(mxConstants.STYLE_BENDABLE, "1");
        hashtable.put(mxConstants.STYLE_GRADIENTCOLOR, GraphWrapper.colorToHexRepresentation(Color.PINK));
        mxStylesheet2.putCellStyle(STYLE_REDUCED_EDGE, hashtable);
    }

    private Hashtable<String, Object> getBasicNodeStyle(String string, Color color) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put(mxConstants.STYLE_SHAPE, string);
        hashtable.put(mxConstants.STYLE_OPACITY, 50);
        hashtable.put(mxConstants.STYLE_GRADIENTCOLOR, GraphWrapper.colorToHexRepresentation(color));
        hashtable.put(mxConstants.STYLE_RESIZABLE, 0);
        hashtable.put(mxConstants.STYLE_CLONEABLE, 0);
        return hashtable;
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public mxUndoManager getUndoManager() {
        return this.undoManager;
    }

    public GraphMouseListener getGraphMouseListener() {
        return this.listener;
    }

    public void setMarkovChain(MarkovChain markovChain) {
        this.clearGraph();
        this.markovChain = markovChain;
        for (int i = 0; i < this.modificationListeners.size(); ++i) {
            if (!(this.modificationListeners.get(i) instanceof MarkovChain)) continue;
            this.modificationListeners.remove(i);
            break;
        }
        this.modificationListeners.add(markovChain);
        this.graph.getModel().beginUpdate();
        if (markovChain.isReduced()) {
            this.drawReducedMarkovChain();
        } else {
            this.drawMarkovChain();
        }
        this.graph.getModel().endUpdate();
        this.setLayout(LayoutType.PARALLEL_EDGE);
        this.centerInitial();
        this.updateDisplayedGraph();
    }

    public Node getSelectedNode() {
        if (this.isSelectionEmpty()) {
            return null;
        }
        mxCell mxCell2 = (mxCell)this.graph.getSelectionCell();
        if (mxCell2.isVertex()) {
            return (Node)mxCell2.getValue();
        }
        return null;
    }

    public Edge getSelectedEdge() {
        if (this.isSelectionEmpty()) {
            return null;
        }
        mxCell mxCell2 = (mxCell)this.graph.getSelectionCell();
        if (mxCell2.isEdge()) {
            return (Edge)mxCell2.getValue();
        }
        return null;
    }

    public void clearSelection() {
        this.graph.clearSelection();
    }

    public void setSelectedNode(Node node) {
        this.setSelectedNode(node, false);
    }

    public void setSelectedNode(Node node, boolean bl) {
        if (node.getGraphCell() == null) {
            return;
        }
        if (bl) {
            this.graph.addSelectionCell(node.getGraphCell());
        } else {
            this.graph.setSelectionCell(node.getGraphCell());
        }
    }

    public void setSelectedEdge(Edge edge) {
        if (edge.getGraphCell() == null) {
            return;
        }
        this.graph.setSelectionCell(edge.getGraphCell());
    }

    public boolean isSelectionEmpty() {
        return this.graph.isSelectionEmpty();
    }

    public boolean isGraphEmpty() {
        return this.graph.getModel().getChildCount(this.graph.getDefaultParent()) == 0;
    }

    private void drawMarkovChain() {
        int[] nArray = new int[]{0, 0};
        this.graph.getModel().beginUpdate();
        for (Node comparable : this.markovChain.getNodes()) {
            double[] dArray = comparable.isPositionSet() ? new double[]{comparable.getXpos() - 40.0, comparable.getYpos() - 40.0} : this.getGridPos(nArray);
            this.addNodeToGraph(comparable, dArray);
        }
        for (Edge edge : this.markovChain.getEdges()) {
            this.addEdgeToGraph(edge);
        }
        this.graph.getModel().endUpdate();
    }

    private void drawReducedMarkovChain() {
        double[] dArray;
        int[] nArray = new int[]{0, 0};
        for (Node comparable : this.markovChain.getInputNodes()) {
            this.markovChain.setReducedNode(comparable, true);
            dArray = this.getGridPos(nArray);
            this.addNodeToGraph(comparable, dArray);
        }
        for (Node node : this.markovChain.getTargetNodes()) {
            dArray = this.getGridPos(nArray);
            this.addNodeToGraph(node, dArray);
        }
        if (this.markovChain.getReducedEdges().size() == 0) {
            Node node = this.markovChain.getInputNodes().first();
            this.expandSCC(node);
            this.markovChain.setInputOfSccNode(node, false);
            this.markovChain.setExpandedInGraph(false);
        } else {
            for (Edge edge : this.markovChain.getReducedEdges()) {
                this.addEdgeToGraph(edge);
            }
        }
    }

    private int[] getGrid(double[] dArray) {
        if (dArray.length < 2) {
            return null;
        }
        int n = (int)(dArray[0] / 100.0);
        int n2 = (int)(dArray[1] / 100.0);
        int[] nArray = new int[]{n, n2};
        return nArray;
    }

    private double[] getGridPos(int[] nArray) {
        if (nArray.length < 2) {
            return null;
        }
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = (int)Math.sqrt(this.markovChain.getNumberOfNodes());
        double[] dArray = new double[]{n * 100, n2 * 100};
        if (++n % n3 == 0) {
            n = 0;
        }
        nArray[0] = n;
        nArray[1] = ++n2;
        return dArray;
    }

    public void redrawMarkovChain() {
        this.clearGraph();
        this.graph.getModel().beginUpdate();
        if (this.markovChain.isReduced()) {
            this.drawReducedMarkovChain();
        } else {
            this.drawMarkovChain();
        }
        this.graph.getModel().endUpdate();
    }

    private void setCursor(Cursor cursor) {
        mxGraphHandler.DEFAULT_CURSOR = cursor;
    }

    public void addNodeToGraph(Node node) {
        if (node.isPositionSet()) {
            this.addNodeToGraph(node, node.getXpos(), node.getYpos());
        } else {
            this.addNodeToGraph(node, 100.0, 100.0);
        }
    }

    public void addNodeToGraph(Node node, double[] dArray) {
        if (dArray.length < 2) {
            return;
        }
        this.addNodeToGraph(node, dArray[0], dArray[1]);
    }

    public void addNodeToGraph(Node node, double d, double d2) {
        this.addNodeToGraph(node, this.graph.getDefaultParent(), d, d2);
    }

    public void addNodeToGraph(Node node, Object object, double d, double d2) {
        if (node.isPositionSet()) {
            d = node.getXpos();
            d2 = node.getYpos();
        }
        if (this.graph.isEnabled()) {
            node.setGraphCell((mxCell)this.graph.insertVertex(object, null, node, d, d2, 40.0, 40.0));
            node.adjustStyle();
        }
        this.outputPanel.getTabNodes().addNode(node);
        this.outputPanel.getTabTargetNodes().addNode(node);
    }

    public mxCell addNodeCell(double d, double d2) {
        mxCell mxCell2 = (mxCell)this.graph.insertVertex(this.graph.getDefaultParent(), null, null, d, d2, 40.0, 40.0, STYLE_DEFAULT_NODE);
        this.fireGraphModification(0, mxCell2);
        return mxCell2;
    }

    public void addEdgeToGraph(Edge edge) {
        this.addEdgeToGraph(edge, this.graph.getDefaultParent());
    }

    public void addEdgeToGraph(Edge edge, Object object) {
        if (this.graph.isEnabled()) {
            edge.setGraphCell((mxCell)this.graph.insertEdge(object, null, edge, edge.getSourceNode().getGraphCell(), edge.getTargetNode().getGraphCell(), edge.isReduced() ? STYLE_REDUCED_EDGE : STYLE_DEFAULT_EDGE));
        }
        this.outputPanel.getTabEdges().addEdge(edge);
    }

    public mxCell addEdgeCell(mxCell mxCell2, mxCell mxCell3) {
        mxCell mxCell4 = (mxCell)this.graph.insertEdge(this.graph.getDefaultParent(), null, null, mxCell2, mxCell3, STYLE_DEFAULT_EDGE);
        mxCell4.setStyle(STYLE_DEFAULT_EDGE);
        this.fireGraphModification(2, mxCell4);
        return mxCell4;
    }

    private void hideNode(Node node) {
        if (node == null || node.isHidden() || node.getGraphCell() == null) {
            return;
        }
        for (Edge edge : this.markovChain.getConnections(node)) {
            this.hideEdge(edge);
        }
        if (this.graph.isEnabled()) {
            node.getGraphCell().setVisible(false);
        }
        node.setHidden(true);
        this.outputPanel.getTabNodes().removeNode(node);
    }

    private void unHideNode(Node node) {
        if (node == null || !node.isHidden() || node.getGraphCell() == null) {
            return;
        }
        if (this.graph.isEnabled()) {
            node.getGraphCell().setVisible(true);
        }
        node.setHidden(false);
        this.outputPanel.getTabNodes().addNode(node);
    }

    public void setNodesVisible(Node[] nodeArray, boolean bl) {
        for (Node node : nodeArray) {
            if (node.getGraphCell() == null) continue;
            if (this.graph.isEnabled()) {
                node.getGraphCell().setVisible(bl);
            }
            node.setHidden(!bl);
        }
        this.updateDisplayedGraph();
    }

    private void hideEdge(Edge edge) {
        if (edge == null || edge.isHidden() || edge.getGraphCell() == null) {
            return;
        }
        this.removeCell(edge.getGraphCell(), false);
        edge.setHidden(true);
        this.outputPanel.getTabEdges().removeEdge(edge);
    }

    private void unHideEdge(Edge edge) {
        if (edge == null || !edge.isHidden() || edge.getGraphCell() == null) {
            return;
        }
        this.addEdgeToGraph(edge);
        edge.setHidden(false);
        this.outputPanel.getTabEdges().addEdge(edge);
    }

    public void removeEdge(Edge edge) {
        this.removeCell(edge.getGraphCell());
    }

    public void removeNode(Node node) {
        this.removeCell(node.getGraphCell());
    }

    public void removeCell(mxCell mxCell2) {
        this.removeCell(mxCell2, true);
    }

    public void removeCell(mxCell mxCell2, boolean bl) {
        if (this.graph.isEnabled()) {
            this.removeCells(new mxCell[]{mxCell2}, bl);
        }
    }

    public void removeCells(mxCell[] mxCellArray, boolean bl) {
        this.graph.setSelectionCells(mxCellArray);
        boolean bl2 = this.graph.isCellsDeletable();
        if (!bl2) {
            this.graph.setCellsDeletable(true);
        }
        if (!bl) {
            this.graph.setEventsEnabled(false);
        }
        if (this.graph.isEnabled()) {
            this.graph.removeCells();
        }
        if (!bl) {
            this.graph.setEventsEnabled(true);
        }
        if (!bl2) {
            this.graph.setCellsDeletable(false);
        }
    }

    public void sourroundNodesWithRectangle(Node[] nodeArray) {
        ArrayList<mxCell> arrayList = new ArrayList<mxCell>();
        for (Node node : nodeArray) {
            if (node.getGraphCell() == null) continue;
            arrayList.add(node.getGraphCell());
        }
        Serializable[] serializableArray = arrayList.toArray(new mxCell[0]);
        this.graph.groupCells(null, 2.0, serializableArray);
        this.updateDisplayedGraph();
    }

    public void sourroundNodeWithRectangle(Node node) {
        this.sourroundNodesWithRectangle(new Node[]{node});
    }

    public void clearGraph() {
        this.graph = new CustomGraph();
        this.graphComponent.setGraph(this.graph);
        this.initGraph();
        this.graphComponent.refresh();
    }

    public void deleteSelectedNodes() {
        if (!this.graph.isSelectionEmpty()) {
            for (Object object : this.graph.getSelectionCells()) {
                mxCell mxCell2 = (mxCell)object;
                if (mxCell2.isVertex()) {
                    for (Edge edge : this.markovChain.getConnections((Node)mxCell2.getValue())) {
                        this.removeEdge(edge);
                    }
                    this.removeCell(mxCell2);
                    continue;
                }
                if (!mxCell2.isEdge()) continue;
                this.removeCell(mxCell2);
            }
            this.graph.removeCells(this.graph.getSelectionCells(), true);
        }
    }

    public void reduceSCC(Node node) {
        if (node == null || node.isReduced()) {
            return;
        }
        this.reduceSCC(node.getCorrespondingMarkovChain());
        this.updateDisplayedGraph();
        if (SCC_MC.getInstance().getGui().isHideAbsorbingNodes()) {
            SCC_MC.getInstance().getGui().hideAbsorbingNodes(true);
        }
    }

    private void reduceSCC(MarkovChain markovChain) {
        if (markovChain.getInitialNode() != null) {
            markovChain.setReducedNode(markovChain.getInitialNode(), true);
        }
        for (Node comparable : markovChain.getInputNodes()) {
            markovChain.setReducedNode(comparable, true);
        }
        markovChain.setExpandedInGraph(false);
        for (Edge edge : markovChain.getEdges()) {
            this.hideEdge(edge);
        }
        for (MarkovChain markovChain2 : markovChain.getSubgraphs()) {
            this.reduceSCC(markovChain2);
            for (Edge edge : markovChain2.getReducedEdges()) {
                this.hideEdge(edge);
            }
            for (Node node : markovChain2.getInputNodes()) {
                this.hideNode(node);
            }
        }
        for (Edge edge : markovChain.getReducedEdges()) {
            this.unHideEdge(edge);
        }
        for (Node node : markovChain.getNodes()) {
            if (node.getGraphCell() == null || node.getGraphCell().getEdgeCount() != 0) continue;
            this.hideNode(node);
        }
    }

    public void expandSCC(Node node) {
        Object object;
        if (node == null || !node.isReduced()) {
            return;
        }
        boolean bl = true;
        int n = node.getCorrespondingMarkovChain().getNumberOfEdges() - node.getCorrespondingMarkovChain().getNumberOfReducedEdges();
        for (MarkovChain object22 : node.getCorrespondingMarkovChain().getSubgraphs()) {
            n += object22.getNumberOfReducedEdges();
        }
        if (n > Config.edgeCountVisible) {
            object = "The expanded graph would have " + n + " additional edges." + Output.getLineBreak() + "This might cause problems while displaying." + Output.getLineBreak() + "Would you like to display the graph anyhow?";
            bl = GUI.showYesNoQuestion("Show graph?", (String)object);
        }
        if (!bl) {
            this.clearGraph();
            this.setGraphEnabled(false);
        }
        node.getCorrespondingMarkovChain().setReducedNode(node, false);
        node.getCorrespondingMarkovChain().setExpandedInGraph(true);
        for (Edge edge : node.getCorrespondingMarkovChain().getReducedEdges()) {
            this.hideEdge(edge);
        }
        object = new double[]{0.0, 0.0};
        if (bl) {
            object[0] = node.getGraphCell().getGeometry().getX();
            object[1] = node.getGraphCell().getGeometry().getY();
        }
        int[] nArray = this.getGrid((double[])object);
        nArray[1] = nArray[1] + 1;
        for (MarkovChain markovChain : node.getCorrespondingMarkovChain().getSubgraphs()) {
            for (Node node2 : markovChain.getInputNodes()) {
                markovChain.setReducedNode(node2, true);
                if (node2.isHidden()) {
                    this.unHideNode(node2);
                    continue;
                }
                double[] dArray = this.getGridPos(nArray);
                this.addNodeToGraph(node2, dArray);
            }
            for (Edge edge : markovChain.getReducedEdges()) {
                this.drawEdge(edge, nArray);
            }
        }
        for (Edge edge : node.getCorrespondingMarkovChain().getEdges()) {
            this.drawEdge(edge, nArray);
        }
        this.updateDisplayedGraph();
        if (SCC_MC.getInstance().getGui().isHideAbsorbingNodes()) {
            SCC_MC.getInstance().getGui().hideAbsorbingNodes(true);
        }
    }

    public int[] getConcretizedGraphs() {
        Object object;
        LinkedList<MarkovChain> linkedList = new LinkedList<MarkovChain>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        linkedList.add(this.markovChain);
        while (!linkedList.isEmpty()) {
            object = (MarkovChain)linkedList.pollFirst();
            linkedList.addAll(((MarkovChain)object).getSubgraphs());
            if (!((MarkovChain)object).isExpandedInGraph()) continue;
            arrayList.add(((MarkovChain)object).getId());
        }
        object = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object[i] = (Integer)arrayList.get(i);
        }
        return object;
    }

    private void drawEdge(Edge edge, int[] nArray) {
        double[] dArray;
        Node node = edge.getSourceNode();
        if (node.isHidden()) {
            this.unHideNode(node);
        } else if (node.getGraphCell() == null) {
            dArray = this.getGridPos(nArray);
            this.addNodeToGraph(node, dArray);
        }
        node = edge.getTargetNode();
        if (node.isHidden()) {
            this.unHideNode(node);
        } else if (node.getGraphCell() == null) {
            dArray = this.getGridPos(nArray);
            this.addNodeToGraph(node, dArray);
        }
        if (edge.isHidden()) {
            this.unHideEdge(edge);
        } else {
            this.addEdgeToGraph(edge);
        }
    }

    public void changeProbability(Edge edge) {
        double d = 0.0;
        d = GUI.getProbability("Please enter the probability", edge.getProbability());
        if (d != 0.0) {
            try {
                this.markovChain.setProbabilityEdge(edge, d);
            }
            catch (ProbabilityExceededException probabilityExceededException) {
                Output.print(probabilityExceededException.toString());
            }
            this.graphComponent.refresh();
            this.outputPanel.getTabEdges().changeEdge(edge);
        }
    }

    public void setInitialNodeColor(Color color) {
        this.initialNodeColor = color;
        this.registerStyles();
        this.updateDisplayedGraph();
    }

    public void setTargetNodeColor(Color color) {
        this.targetNodeColor = color;
        this.registerStyles();
        this.updateDisplayedGraph();
    }

    public void setDefaultNodeColor(Color color) {
        this.defaultNodeColor = color;
        this.registerStyles();
        this.updateDisplayedGraph();
    }

    public void setReducedNodeColor(Color color) {
        this.reducedNodeColor = color;
        this.registerStyles();
        this.updateDisplayedGraph();
    }

    public Color getInitialNodeColor() {
        return this.initialNodeColor;
    }

    public Color getTargetNodeColor() {
        return this.targetNodeColor;
    }

    public Color getDefaultNodeColor() {
        return this.defaultNodeColor;
    }

    public Color getReducedNodeColor() {
        return this.reducedNodeColor;
    }

    private int getMean(int n, int n2) {
        return (n + n2) / 2;
    }

    private Color mixColor(Color color, Color color2) {
        int n = this.getMean(color.getRed(), color2.getRed());
        int n2 = this.getMean(color.getGreen(), color2.getGreen());
        int n3 = this.getMean(color.getBlue(), color2.getBlue());
        return new Color(n, n2, n3);
    }

    public void rescaleByFactor(double d) {
        mxGraphView mxGraphView2 = this.graph.getView();
        mxGraphView2.setScale(mxGraphView2.getScale() * d);
    }

    public void rescaleToAbsoluteValue(double d) {
        mxGraphView mxGraphView2 = this.graph.getView();
        mxGraphView2.setScale(d / 100.0);
    }

    public void setLayout(LayoutType layoutType) {
        mxGraphLayout mxGraphLayout2;
        switch (layoutType) {
            case GRID: {
                this.redrawMarkovChain();
                return;
            }
            case FASTORGANIC: {
                mxFastOrganicLayout mxFastOrganicLayout2 = new mxFastOrganicLayout(this.graph);
                mxFastOrganicLayout2.setForceConstant(200.0);
                mxFastOrganicLayout2.setInitialTemp(200.0);
                mxFastOrganicLayout2.setMinDistanceLimit(10.0);
                mxFastOrganicLayout2.setMaxDistanceLimit(500.0);
                mxGraphLayout2 = mxFastOrganicLayout2;
                break;
            }
            case TREE: {
                mxGraphLayout2 = new mxCompactTreeLayout(this.graph);
                break;
            }
            case CIRCLE: {
                mxGraphLayout2 = new mxCircleLayout(this.graph);
                break;
            }
            case PARALLEL_EDGE: {
                mxGraphLayout2 = new mxParallelEdgeLayout(this.graph);
                break;
            }
            case PARTITION: {
                mxGraphLayout2 = new mxPartitionLayout(this.graph);
                break;
            }
            case STACK: {
                mxGraphLayout2 = new mxStackLayout(this.graph);
                break;
            }
            case HIERARCHICAL: {
                mxGraphLayout2 = new mxHierarchicalLayout(this.graph);
                break;
            }
            default: {
                mxGraphLayout2 = null;
            }
        }
        boolean bl = this.graph.isCellsMovable();
        this.graph.setCellsMovable(true);
        for (Edge edge : this.markovChain.getEdges()) {
            if (edge.getGraphCell() == null) continue;
            edge.getGraphCell().getGeometry().setPoints(null);
        }
        this.otherLayoutBefore = true;
        mxGraphLayout2.execute(this.graph.getDefaultParent());
        this.graph.setCellsMovable(bl);
        this.updateDisplayedGraph();
    }

    public void lockGraph(boolean bl) {
        this.graph.setCellsDeletable(!bl);
    }

    public void setGraphEnabled(boolean bl) {
        if (!bl) {
            this.clearGraph();
        }
        this.lockGraph(!bl);
        this.graph.setEnabled(bl);
        if (!SCC_MC.getInstance().isGraphLocked()) {
            SCC_MC.getInstance().getGui().getToolbar().getToolbarEdit().makeEnabled(bl);
        }
        if (bl) {
            this.graphComponent.getViewport().setBackground(Color.WHITE);
        } else {
            this.graphComponent.getViewport().setBackground(Color.GRAY);
        }
    }

    public void beginUpdate() {
        this.graph.getModel().beginUpdate();
    }

    public void endUpdate() {
        this.graph.getModel().endUpdate();
    }

    public void updateDisplayedGraph() {
        this.graph.refresh();
    }

    public void hideIsolatedNodes(boolean bl) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.markovChain.getNodes()) {
            if (node.hasAdjacentNodes()) continue;
            arrayList.add(node);
        }
        this.setNodesVisible(arrayList.toArray(new Node[0]), !bl);
    }

    public void hideAbsorbingNodes(boolean bl) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.markovChain.getNodes()) {
            if (!node.isAbsorbing() || node.isTarget()) continue;
            arrayList.add(node);
        }
        this.setNodesVisible(arrayList.toArray(new Node[0]), !bl);
    }

    public void requestFocusForGraph() {
        this.graphComponent.requestFocus();
    }

    public void centerInitial() {
        this.centerNode(this.markovChain.getInitialNode());
    }

    public void centerNode(Node node) {
        if (node != null) {
            this.centerCell(node.getGraphCell());
            this.setSelectedNode(node);
        }
    }

    public void centerEdge(Edge edge) {
        if (edge != null) {
            this.centerCell(edge.getGraphCell());
            this.setSelectedEdge(edge);
        }
    }

    public void centerCell(mxCell mxCell2) {
        this.graphComponent.scrollCellToVisible(mxCell2, true);
    }

    public mxCell getCellUnderMouse(MouseEvent mouseEvent) {
        mxPoint mxPoint2 = new mxPoint(mouseEvent.getX(), mouseEvent.getY());
        mxCell mxCell2 = (mxCell)this.graphComponent.getCellAt((int)mxPoint2.getX(), (int)mxPoint2.getY());
        return mxCell2;
    }

    private static String colorToHexRepresentation(Color color) {
        String string = Integer.toHexString(color.getRGB());
        if (string.length() > 6) {
            string = string.substring(string.length() - 6);
        }
        while (string.length() < 6) {
            string = '0' + string;
        }
        return '#' + string;
    }

    private static String cellToString(mxCell mxCell2) {
        if (mxCell2 != null) {
            if (mxCell2.isVertex()) {
                Node node = (Node)mxCell2.getValue();
                return "Vtx: " + node.getNumber();
            }
            return "Edg: " + mxCell2.getValue().toString();
        }
        return "null";
    }

    public static enum LayoutType {
        FASTORGANIC,
        GRID,
        TREE,
        HIERARCHICAL,
        CIRCLE,
        PARALLEL_EDGE,
        PARTITION,
        STACK,
        NONE;

    }
}

