/*
 * Decompiled with CFR 0.152.
 */
package comics.gui;

import comics.SCC_MC;
import comics.data.Config;
import comics.graph.data.Labels;
import comics.graph.data.MarkovChain;
import comics.graph.gui.GraphWrapper;
import comics.gui.ContextMenu;
import comics.gui.Statusbar;
import comics.gui.Toolbar;
import comics.gui.actions.FileMenuActionListener;
import comics.gui.actions.GraphLayoutAction;
import comics.gui.actions.NodeColorAction;
import comics.gui.actions.ToolMenuActionListener;
import comics.gui.actions.ZoomAbsoluteAction;
import comics.gui.actions.ZoomRelativeAction;
import comics.gui.output_panel.OutputPanel;
import comics.utilities.Output;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Scanner;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class GUI
extends JPanel {
    private static final long serialVersionUID = 1L;
    private boolean hideIsolatedNodes;
    private boolean hideAbsorbingNodes;
    private static JFrame frame;
    private JMenu graphMenu;
    private JMenu colorMenu;
    private JMenu layoutMenu;
    private JMenu zoomMenu;
    private JMenu fileMenu;
    private JMenu toolMenu;
    private JMenu infoMenu;
    private JMenuItem loadLabItem;
    private JMenuItem hideIsolatedNodesItem;
    private JMenuItem hideAbsorbingNodesItem;
    private JMenuBar menuBar;
    private Statusbar statusBar;
    private Toolbar toolbar;
    private OutputPanel outputPanel;
    private ContextMenu contextMenu;
    public GraphWrapper wrapper;
    private SCC_MC scc_mc;

    public GUI(SCC_MC sCC_MC) {
        this.scc_mc = sCC_MC;
        this.init();
    }

    public static JFrame getFrame() {
        return frame;
    }

    private void init() {
        System.setProperty("sun.java2d.d3d", "false");
        frame = new JFrame("COMICS 1.0");
        this.statusBar = new Statusbar(1);
        this.outputPanel = new OutputPanel();
        this.contextMenu = new ContextMenu();
        this.initGraphWrapper();
        this.initMenus();
        this.toolbar = new Toolbar(this);
        frame.setDefaultCloseOperation(3);
        frame.setSize(800, 600);
        frame.setBackground(Color.white);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUI.this.scc_mc.terminate();
            }
        });
        frame.setLocationRelativeTo(null);
        Container container = frame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.statusBar, "South");
        container.add((Component)this.toolbar, "First");
        container.add((Component)this.wrapper.getGraphComponent(), "Center");
        container.add((Component)this.outputPanel, "East");
        JSplitPane jSplitPane = new JSplitPane(1, this.wrapper.getGraphComponent(), this.outputPanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(500);
        container.add((Component)jSplitPane, "Center");
        frame.setVisible(true);
    }

    private void initGraphWrapper() {
        this.wrapper = new GraphWrapper(this.outputPanel);
    }

    private void initMenus() {
        this.menuBar = new JMenuBar();
        frame.setJMenuBar(this.menuBar);
        this.addFileMenu();
        this.addToolMenu();
        this.addGraphMenu();
        this.addZoomMenu();
        this.addInfoMenu();
    }

    private void addInfoMenu() {
        this.infoMenu = new JMenu("Help");
        FileMenuActionListener fileMenuActionListener = new FileMenuActionListener(this.scc_mc);
        JMenuItem jMenuItem = new JMenuItem("About");
        jMenuItem.setActionCommand("about");
        jMenuItem.addActionListener(fileMenuActionListener);
        this.infoMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Go to webpage");
        jMenuItem.setActionCommand("link");
        jMenuItem.addActionListener(fileMenuActionListener);
        this.infoMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Open manual");
        jMenuItem.setActionCommand("manual");
        jMenuItem.addActionListener(fileMenuActionListener);
        this.infoMenu.add(jMenuItem);
        this.menuBar.add(this.infoMenu);
    }

    private void addFileMenu() {
        this.fileMenu = new JMenu("File");
        FileMenuActionListener fileMenuActionListener = new FileMenuActionListener(this.scc_mc);
        JMenuItem jMenuItem = new JMenuItem("Reset");
        jMenuItem.setActionCommand("reset");
        jMenuItem.addActionListener(fileMenuActionListener);
        this.fileMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Open file");
        jMenuItem.setActionCommand("open_file");
        jMenuItem.addActionListener(fileMenuActionListener);
        this.fileMenu.add(jMenuItem);
        this.loadLabItem = new JMenuItem("Open labels file");
        this.loadLabItem.setActionCommand("open_labfile");
        this.loadLabItem.addActionListener(fileMenuActionListener);
        this.loadLabItem.setEnabled(false);
        this.fileMenu.add(this.loadLabItem);
        jMenuItem = new JMenuItem("Save");
        jMenuItem.setActionCommand("save");
        jMenuItem.addActionListener(fileMenuActionListener);
        this.fileMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save as XML");
        jMenuItem.setActionCommand("save_as_xml");
        jMenuItem.addActionListener(fileMenuActionListener);
        this.fileMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Export to MRMC");
        jMenuItem.setActionCommand("export_mrmc");
        jMenuItem.addActionListener(fileMenuActionListener);
        this.fileMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Export labels");
        jMenuItem.setActionCommand("export_labels");
        jMenuItem.addActionListener(fileMenuActionListener);
        this.fileMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.setActionCommand("exit");
        jMenuItem.addActionListener(fileMenuActionListener);
        this.fileMenu.add(jMenuItem);
        this.menuBar.add(this.fileMenu);
    }

    private void addToolMenu() {
        this.toolMenu = new JMenu("Tools");
        ToolMenuActionListener toolMenuActionListener = new ToolMenuActionListener(this.scc_mc, this);
        JMenuItem jMenuItem = new JMenuItem("Search states");
        jMenuItem.setActionCommand("search");
        jMenuItem.addActionListener(toolMenuActionListener);
        this.toolMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Center initial state");
        jMenuItem.setActionCommand("centerInitial");
        jMenuItem.addActionListener(toolMenuActionListener);
        this.toolMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Transform to 1 target");
        jMenuItem.setActionCommand("oneTarget");
        jMenuItem.addActionListener(toolMenuActionListener);
        this.toolMenu.add(jMenuItem);
        this.hideIsolatedNodesItem = new JMenuItem("Hide isolated states");
        this.hideIsolatedNodesItem.setActionCommand("hideIsolatedNodes");
        this.hideIsolatedNodesItem.addActionListener(toolMenuActionListener);
        this.hideIsolatedNodes = false;
        this.toolMenu.add(this.hideIsolatedNodesItem);
        this.hideAbsorbingNodesItem = new JMenuItem("Hide absorbing states");
        this.hideAbsorbingNodesItem.setActionCommand("hideAbsorbingNodes");
        this.hideAbsorbingNodesItem.addActionListener(toolMenuActionListener);
        this.hideAbsorbingNodes = false;
        this.toolMenu.add(this.hideAbsorbingNodesItem);
        jMenuItem = new JMenuItem("Check consistency");
        jMenuItem.setActionCommand("checkConsistency");
        jMenuItem.addActionListener(toolMenuActionListener);
        this.toolMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Choose label for initial state");
        jMenuItem.setActionCommand("chooseLabelInitial");
        jMenuItem.addActionListener(toolMenuActionListener);
        this.toolMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Choose label for target states");
        jMenuItem.setActionCommand("chooseLabelTarget");
        jMenuItem.addActionListener(toolMenuActionListener);
        this.toolMenu.add(jMenuItem);
        this.menuBar.add(this.toolMenu);
    }

    private void addGraphMenu() {
        this.graphMenu = new JMenu("Graph");
        this.colorMenu = new JMenu("Choose colour");
        this.graphMenu.add(this.colorMenu);
        this.layoutMenu = new JMenu("Layout");
        this.graphMenu.add(this.layoutMenu);
        this.colorMenu.add(new NodeColorAction(this, 1));
        this.colorMenu.add(new NodeColorAction(this, 2));
        this.colorMenu.add(new NodeColorAction(this, 0));
        this.colorMenu.add(new NodeColorAction(this, 3));
        this.layoutMenu.add(new GraphLayoutAction(this, this.wrapper, GraphWrapper.LayoutType.FASTORGANIC));
        this.layoutMenu.add(new GraphLayoutAction(this, this.wrapper, GraphWrapper.LayoutType.HIERARCHICAL));
        this.layoutMenu.add(new GraphLayoutAction(this, this.wrapper, GraphWrapper.LayoutType.TREE));
        this.layoutMenu.add(new GraphLayoutAction(this, this.wrapper, GraphWrapper.LayoutType.PARTITION));
        this.layoutMenu.add(new GraphLayoutAction(this, this.wrapper, GraphWrapper.LayoutType.STACK));
        this.layoutMenu.add(new GraphLayoutAction(this, this.wrapper, GraphWrapper.LayoutType.CIRCLE));
        this.layoutMenu.add(new GraphLayoutAction(this, this.wrapper, GraphWrapper.LayoutType.PARALLEL_EDGE));
        this.layoutMenu.add(new GraphLayoutAction(this, this.wrapper, GraphWrapper.LayoutType.GRID));
        this.menuBar.add(this.graphMenu);
    }

    private void addZoomMenu() {
        this.zoomMenu = new JMenu("Zoom");
        this.zoomMenu.add(new ZoomRelativeAction(this, true));
        this.zoomMenu.add(new ZoomRelativeAction(this, false));
        this.zoomMenu.add(new ZoomAbsoluteAction(this, 100));
        this.zoomMenu.add(new ZoomAbsoluteAction(this, 75));
        this.zoomMenu.add(new ZoomAbsoluteAction(this, 50));
        this.zoomMenu.add(new ZoomAbsoluteAction(this, 25));
        this.menuBar.add(this.zoomMenu);
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public OutputPanel getOutputPanel() {
        return this.outputPanel;
    }

    public ContextMenu getContextMenu() {
        return this.contextMenu;
    }

    public void setLoadLabItemEnabled(boolean bl) {
        this.loadLabItem.setEnabled(bl);
    }

    public void resetHide() {
        if (this.hideIsolatedNodes) {
            this.toggleHideIsolatedNodes();
        }
        if (this.hideAbsorbingNodes) {
            this.toggleHideAbsorbingNodes();
        }
    }

    public void hideIsolatedNodes(boolean bl) {
        this.hideIsolatedNodes = bl;
        if (this.hideIsolatedNodes) {
            this.hideIsolatedNodesItem.setText("Unhide isolated states");
        } else {
            this.hideIsolatedNodesItem.setText("Hide isolated states");
        }
        this.wrapper.hideIsolatedNodes(this.hideIsolatedNodes);
    }

    public void toggleHideIsolatedNodes() {
        this.hideIsolatedNodes(!this.hideIsolatedNodes);
    }

    public void hideAbsorbingNodes(boolean bl) {
        this.hideAbsorbingNodes = bl;
        if (this.hideAbsorbingNodes) {
            this.hideAbsorbingNodesItem.setText("Unhide absorbing states");
        } else {
            this.hideAbsorbingNodesItem.setText("Hide absorbing states");
        }
        this.wrapper.hideAbsorbingNodes(this.hideAbsorbingNodes);
    }

    public void toggleHideAbsorbingNodes() {
        this.hideAbsorbingNodes(!this.hideAbsorbingNodes);
    }

    public boolean isHideAbsorbingNodes() {
        return this.hideAbsorbingNodes;
    }

    public void popSearchMenu(boolean bl) {
        boolean bl2 = true;
        if (bl) {
            String string = JOptionPane.showInputDialog(GUI.getFrame(), (Object)("Which nodes should be highlighted?" + Output.getLineBreak() + "Seperate Nodes by blanks"));
            if (string != null && !string.isEmpty() && this.scc_mc.getMarkovChain() != null) {
                if (string.matches(".*answer.*") && 42 <= this.scc_mc.getMaxNode()) {
                    this.scc_mc.searchNode(42, true);
                } else {
                    Scanner scanner = new Scanner(string).useDelimiter("\\s* ");
                    this.wrapper.clearSelection();
                    while (scanner.hasNextInt()) {
                        int n = scanner.nextInt();
                        if (n < this.scc_mc.getMaxNode() + 1 && n > 0) {
                            this.scc_mc.searchNode(n, bl2);
                            bl2 = false;
                            continue;
                        }
                        this.popSearchMenu2();
                    }
                }
            }
        } else {
            GUI.showErrorMessage("There are no connected nodes");
        }
    }

    public void popSearchMenu2() {
        boolean bl = true;
        String string = JOptionPane.showInputDialog(GUI.getFrame(), (Object)"State not found...try again");
        if (string != null && !string.isEmpty() && this.scc_mc.getMarkovChain() != null) {
            Scanner scanner = new Scanner(string).useDelimiter("\\s*");
            this.wrapper.clearSelection();
            while (scanner.hasNextInt()) {
                int n = scanner.nextInt();
                if (n < this.scc_mc.getMaxNode() + 1 && n > 0) {
                    this.scc_mc.searchNode(n, bl);
                    bl = false;
                    continue;
                }
                this.popSearchMenu2();
            }
        }
    }

    public void setStatusBarMessage(String string) {
        this.statusBar.setText(0, string);
    }

    public void showInfo() {
        ImageIcon imageIcon;
        URL uRL = this.getClass().getResource(Config.pathToLogo);
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL, "COMICS Logo");
        } else {
            imageIcon = null;
            Output.print("Couldn't find file");
        }
        String string = "<html><h1>Comics 1.0</h1>";
        string = string + "<h2>Computing Minimal Subsystems</h2><br><ul>";
        string = string + "<u>Authors:</u><br><ul>";
        string = string + "<li>Nils Jansen</li>";
        string = string + "<li>Erika Abraham</li>";
        string = string + "<li>Jens Katelaan</li>";
        string = string + "<li>Maik Scheffler</li>";
        string = string + "<li>Matthias Volk</li>";
        string = string + "<li>Andreas Vorpahl</li></ul>";
        string = string + "<br><a href=\"" + Config.url + "\">" + Config.url + "</a><br><br>";
        string = string + "COMICS is distributed under the GPL conditions.<br>";
        string = string + "The product comes with ABSOLUTELY NO WARRANTY.<br>";
        string = string + "This is a free software, and you are welcome to redistribute it.<br>";
        string = string + "<html>";
        JOptionPane.showMessageDialog(GUI.getFrame(), string, "Info", -1, imageIcon);
    }

    public static double getProbability(String string) {
        return GUI.getProbability(string, 1.0);
    }

    public static double getProbability(String string, double d) {
        double d2 = 0.0;
        while (true) {
            d2 = 0.0;
            String string2 = JOptionPane.showInputDialog(GUI.getFrame(), string, d);
            try {
                if (string2 == null) {
                    return 0.0;
                }
                string2 = string2.replace(",", ".");
                d2 = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                GUI.showWarningMessage("Please enter a double!");
            }
            if (MarkovChain.isConsistent(d2)) break;
            GUI.showWarningMessage("Please enter a number between 0 and 1!");
        }
        return d2;
    }

    public static Labels showLabelList(Labels labels, String string) {
        JLabel jLabel = new JLabel(string);
        JList<Object> jList = new JList<Object>(labels.toArray());
        Object[] objectArray = new Object[]{jLabel, jList};
        JOptionPane.showMessageDialog(GUI.getFrame(), objectArray, string, -1);
        Labels labels2 = new Labels();
        for (Object object : jList.getSelectedValues()) {
            labels2.add((String)object);
        }
        return labels2;
    }

    public static void showMessage(String string, String string2, int n) {
        Output.print(string2 + ": " + string);
        JOptionPane.showMessageDialog(GUI.getFrame(), string, string2, n);
    }

    public static void showErrorMessage(String string) {
        GUI.showMessage(string, "Error (DON'T PANIC!)", 0);
    }

    public static void showWarningMessage(String string) {
        GUI.showMessage(string, "Warning", 2);
    }

    public static void showInfoMessage(String string) {
        GUI.showMessage(string, "Information", 1);
    }

    public static boolean showYesNoQuestion(String string, String string2) {
        int n = JOptionPane.showConfirmDialog(GUI.getFrame(), string2, string, 0);
        return n == 0;
    }
}

