/*
 * Decompiled with CFR 0.152.
 */
package comics.gui.output_panel;

import comics.SCC_MC;
import comics.graph.data.Edge;
import comics.gui.output_panel.OverviewPanel;
import comics.gui.output_panel.SortedListModel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class TabEdges
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private JList list;
    private SortedListModel<Edge> listModel;
    private OverviewPanel overviewPanel;

    public TabEdges(OverviewPanel overviewPanel) {
        this.setName("Edges");
        this.overviewPanel = overviewPanel;
        this.listModel = new SortedListModel();
        this.list = new JList<Edge>(this.listModel);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new EdgeRenderer());
        this.setViewportView(this.list);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JList jList = (JList)mouseEvent.getSource();
                if (mouseEvent.getClickCount() == 2) {
                    int n = jList.locationToIndex(mouseEvent.getPoint());
                    Edge edge = (Edge)TabEdges.this.listModel.getElementAt(n);
                    SCC_MC.getInstance().getGui().wrapper.centerEdge(edge);
                }
            }
        });
    }

    public void clear() {
        this.listModel.clear();
    }

    public void addEdge(Edge edge) {
        this.listModel.add(edge);
        this.overviewPanel.reloadValues();
    }

    public void changeEdge(Edge edge) {
        this.listModel.removeElement(edge);
        this.listModel.add(edge);
        this.overviewPanel.reloadValues();
    }

    public void removeEdge(Edge edge) {
        this.listModel.removeElement(edge);
        this.overviewPanel.reloadValues();
    }

    public int getEdgeCount() {
        return this.listModel.getSize();
    }

    public class EdgeRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Edge edge = (Edge)object;
            String string = edge.toPropertyString();
            if (edge.isReduced()) {
                string = string + " (Reduced)";
            }
            this.setText(string);
            return this;
        }
    }
}

