/*
 * Decompiled with CFR 0.152.
 */
package comics.io.output;

import com.mxgraph.model.mxGeometry;
import comics.graph.data.Edge;
import comics.graph.data.MarkovChain;
import comics.graph.data.Node;
import comics.io.output.OutputFormatter;
import comics.utilities.Output;
import java.io.File;

public class XmlWriter
extends OutputFormatter {
    private boolean keepAbstract;
    private double probModelCheck;
    private String lb;

    public XmlWriter(MarkovChain markovChain, boolean bl, double d) {
        this(markovChain, null, bl, d);
        this.lb = Output.getLineBreak();
    }

    public XmlWriter(MarkovChain markovChain, File file, boolean bl, double d) {
        super(markovChain, file);
        this.keepAbstract = bl;
        this.probModelCheck = d;
        this.lb = Output.getLineBreak();
    }

    @Override
    protected String generateString(MarkovChain markovChain) {
        return this.markovChainToXMLString(markovChain);
    }

    public String markovChainToXMLString(MarkovChain markovChain) {
        String string = "";
        string = string + "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        string = string + this.lb + "<dtmc>" + this.lb;
        string = string + this.recursiveTransformation(markovChain, 1);
        for (Node node : markovChain.getTargetNodes()) {
            if (!node.isTarget()) continue;
            string = string + "  <target>" + node.getNumber() + "</target>" + this.lb;
        }
        string = string + "  <prob>" + this.probModelCheck + "</prob>" + this.lb;
        string = string + "</dtmc>";
        return string;
    }

    String edgeTag(Edge edge) {
        String string = "";
        string = string + "<edg abs=\"" + (edge.isReduced() ? 1 : 0);
        string = string + "\" prb=\"" + edge.getProbability();
        string = string + "\" src=\"" + edge.getSourceNode().getNumber();
        string = string + "\" trg=\"" + edge.getTargetNode().getNumber();
        string = string + "\" />" + this.lb;
        return string;
    }

    String recursiveTransformation(MarkovChain markovChain, int n) {
        int n2;
        String string = "";
        String string2 = "";
        for (n2 = 1; n2 < n; ++n2) {
            string2 = string2 + "  ";
        }
        if (this.keepAbstract || markovChain.getRecursionDepth() == 0 || !markovChain.isExpandedInGraph()) {
            string2 = string2 + "  ";
            string = string + string2 + "<scc";
            string = string + " id=\"" + markovChain.getId() + "\"";
            n2 = 0;
            if (markovChain.getInitialNode() != null) {
                string = string + " node0=\"" + markovChain.getInitialNode().getNumber() + "\"";
            } else {
                for (Node node : markovChain.getInputNodes()) {
                    string = string + " node" + n2 + "=\"" + node.getNumber() + "\"";
                    ++n2;
                }
            }
            string = string + ">" + this.lb;
            if (markovChain.isReduced()) {
                for (Node node : markovChain.getInputNodes()) {
                    string = string + string2 + "  " + "<inp";
                    if (markovChain.getRecursionDepth() == 0) {
                        string = string + this.getXMLPos(node);
                    }
                    string = string + ">";
                    string = string + node.getNumber() + "</inp>" + this.lb;
                }
            } else {
                string = string + string2 + "  " + "<inp";
                if (markovChain.getRecursionDepth() == 0) {
                    string = string + this.getXMLPos(markovChain.getInitialNode());
                }
                string = string + ">";
                string = string + markovChain.getInitialNode() + "</inp>" + this.lb;
            }
            for (Node node : markovChain.getTargetNodes()) {
                string = string + string2 + "  " + "<out";
                if (markovChain.getRecursionDepth() == 0) {
                    string = string + this.getXMLPos(node);
                }
                string = string + ">";
                string = string + node.getNumber() + "</out>" + this.lb;
            }
            for (Node node : markovChain.getNodes()) {
                if (markovChain.getInputNodes().contains(node) || node.equals(markovChain.getInitialNode()) || markovChain.getTargetNodes().contains(node)) continue;
                string = string + string2 + "  " + "<vtx";
                if (markovChain.getRecursionDepth() == 0) {
                    string = string + this.getXMLPos(node);
                }
                string = string + ">";
                string = string + node.getNumber() + "</vtx>" + this.lb;
            }
        }
        for (MarkovChain markovChain2 : markovChain.getSubgraphs()) {
            string = string + this.recursiveTransformation(markovChain2, n + 1);
        }
        for (Edge edge : markovChain.getEdges()) {
            string = string + string2 + "  " + this.edgeTag(edge);
        }
        if (markovChain.isReduced() && (this.keepAbstract || !markovChain.isExpandedInGraph())) {
            for (Edge edge : markovChain.getReducedEdges()) {
                string = string + string2 + "  " + this.edgeTag(edge);
            }
        }
        if (this.keepAbstract || markovChain.getRecursionDepth() == 0 || !markovChain.isExpandedInGraph()) {
            string = string + string2 + "</scc>" + this.lb;
        }
        return string;
    }

    private String getXMLPos(Node node) {
        if (node.getGraphCell() == null) {
            return "";
        }
        mxGeometry mxGeometry2 = node.getGraphCell().getGeometry();
        String string = " xpos=\"" + mxGeometry2.getX() + "\" ";
        string = string + "ypos=\"" + mxGeometry2.getY() + "\"";
        return string;
    }

    private String printLabels(MarkovChain markovChain, String string) {
        String string2 = string + "<labels>" + this.lb;
        string2 = string2 + string + "  <declaration>" + this.lb;
        for (String object : markovChain.getLabels()) {
            string2 = string2 + string + "    " + "<lab>" + object + "</lab>" + this.lb;
        }
        string2 = string2 + string + "  </declaration>" + this.lb;
        for (Node node : markovChain.getNodes()) {
            string2 = string2 + string + "  <lbvtx id=\"" + node.getNumber() + "\">" + this.lb;
            for (String string3 : markovChain.getLabelsNode(node)) {
                string2 = string2 + string + "    " + "<lab>" + string3 + "</lab>" + this.lb;
            }
            string2 = string2 + string + "  </lbvtx>" + this.lb;
        }
        string2 = string2 + string + "</labels>" + this.lb;
        return string2;
    }
}

