/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.view;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;

public class mxSpaceManager
extends mxEventSource {
    protected mxGraph graph;
    protected boolean enabled;
    protected boolean shiftRightwards;
    protected boolean shiftDownwards;
    protected boolean extendParents;
    protected mxEventSource.mxIEventListener resizeHandler = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object object, mxEventObject mxEventObject2) {
            if (mxSpaceManager.this.isEnabled()) {
                mxSpaceManager.this.cellsResized((Object[])mxEventObject2.getProperty("cells"));
            }
        }
    };

    public mxSpaceManager(mxGraph mxGraph2) {
        this.setGraph(mxGraph2);
    }

    public boolean isCellIgnored(Object object) {
        return !this.getGraph().getModel().isVertex(object);
    }

    public boolean isCellShiftable(Object object) {
        return this.getGraph().getModel().isVertex(object) && this.getGraph().isCellMovable(object);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isShiftRightwards() {
        return this.shiftRightwards;
    }

    public void setShiftRightwards(boolean bl) {
        this.shiftRightwards = bl;
    }

    public boolean isShiftDownwards() {
        return this.shiftDownwards;
    }

    public void setShiftDownwards(boolean bl) {
        this.shiftDownwards = bl;
    }

    public boolean isExtendParents() {
        return this.extendParents;
    }

    public void setExtendParents(boolean bl) {
        this.extendParents = bl;
    }

    public mxGraph getGraph() {
        return this.graph;
    }

    public void setGraph(mxGraph mxGraph2) {
        if (this.graph != null) {
            this.graph.removeListener(this.resizeHandler);
        }
        this.graph = mxGraph2;
        if (this.graph != null) {
            this.graph.addListener("resizeCells", this.resizeHandler);
            this.graph.addListener("foldCells", this.resizeHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cellsResized(Object[] objectArray) {
        if (objectArray != null) {
            mxIGraphModel mxIGraphModel2 = this.getGraph().getModel();
            mxIGraphModel2.beginUpdate();
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (this.isCellIgnored(objectArray[i])) continue;
                    this.cellResized(objectArray[i]);
                    break;
                }
            }
            finally {
                mxIGraphModel2.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cellResized(Object object) {
        mxGraph mxGraph2 = this.getGraph();
        mxGraphView mxGraphView2 = mxGraph2.getView();
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        mxCellState mxCellState2 = mxGraphView2.getState(object);
        mxCellState mxCellState3 = mxGraphView2.getState(mxIGraphModel2.getParent(object));
        if (mxCellState2 != null && mxCellState3 != null) {
            Object[] objectArray = this.getCellsToShift(mxCellState2);
            mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(object);
            if (objectArray != null && mxGeometry2 != null) {
                mxPoint mxPoint2 = mxGraphView2.getTranslate();
                double d = mxGraphView2.getScale();
                double d2 = mxCellState2.getX() - mxCellState3.getOrigin().getX() - mxPoint2.getX() * d;
                double d3 = mxCellState2.getY() - mxCellState3.getOrigin().getY() - mxPoint2.getY() * d;
                double d4 = mxCellState2.getX() + mxCellState2.getWidth();
                double d5 = mxCellState2.getY() + mxCellState2.getHeight();
                double d6 = mxCellState2.getWidth() - mxGeometry2.getWidth() * d + d2 - mxGeometry2.getX() * d;
                double d7 = mxCellState2.getHeight() - mxGeometry2.getHeight() * d + d3 - mxGeometry2.getY() * d;
                double d8 = 1.0 - mxGeometry2.getWidth() * d / mxCellState2.getWidth();
                double d9 = 1.0 - mxGeometry2.getHeight() * d / mxCellState2.getHeight();
                mxIGraphModel2.beginUpdate();
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i] == object || !this.isCellShiftable(objectArray[i])) continue;
                        this.shiftCell(objectArray[i], d6, d7, d2, d3, d4, d5, d8, d9, this.isExtendParents() && mxGraph2.isExtendParent(objectArray[i]));
                    }
                }
                finally {
                    mxIGraphModel2.endUpdate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shiftCell(Object object, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, boolean bl) {
        mxIGraphModel mxIGraphModel2;
        mxGeometry mxGeometry2;
        mxGraph mxGraph2 = this.getGraph();
        mxCellState mxCellState2 = mxGraph2.getView().getState(object);
        if (mxCellState2 != null && (mxGeometry2 = (mxIGraphModel2 = mxGraph2.getModel()).getGeometry(object)) != null) {
            mxIGraphModel2.beginUpdate();
            try {
                double d9;
                if (this.isShiftRightwards()) {
                    if (mxCellState2.getX() >= d5) {
                        mxGeometry2 = (mxGeometry)mxGeometry2.clone();
                        mxGeometry2.translate(-d, 0.0);
                    } else {
                        d9 = Math.max(0.0, mxCellState2.getX() - d3);
                        mxGeometry2 = (mxGeometry)mxGeometry2.clone();
                        mxGeometry2.translate(-d7 * d9, 0.0);
                    }
                }
                if (this.isShiftDownwards()) {
                    if (mxCellState2.getY() >= d6) {
                        mxGeometry2 = (mxGeometry)mxGeometry2.clone();
                        mxGeometry2.translate(0.0, -d2);
                    } else {
                        d9 = Math.max(0.0, mxCellState2.getY() - d4);
                        mxGeometry2 = (mxGeometry)mxGeometry2.clone();
                        mxGeometry2.translate(0.0, -d8 * d9);
                    }
                    if (mxGeometry2 != mxIGraphModel2.getGeometry(object)) {
                        mxIGraphModel2.setGeometry(object, mxGeometry2);
                        if (bl) {
                            mxGraph2.extendParent(object);
                        }
                    }
                }
            }
            finally {
                mxIGraphModel2.endUpdate();
            }
        }
    }

    protected Object[] getCellsToShift(mxCellState mxCellState2) {
        mxGraph mxGraph2 = this.getGraph();
        Object object = mxGraph2.getModel().getParent(mxCellState2.getCell());
        boolean bl = this.isShiftDownwards();
        boolean bl2 = this.isShiftRightwards();
        return mxGraph2.getCellsBeyond(mxCellState2.getX() + (bl ? 0.0 : mxCellState2.getWidth()), mxCellState2.getY() + (bl && bl2 ? 0.0 : mxCellState2.getHeight()), object, bl2, bl);
    }

    public void destroy() {
        this.setGraph(null);
    }
}

