/*
 * Decompiled with CFR 0.152.
 */
package prismparser;

import prismparser.SyntaxTreeGenerator;
import prismparser.TestStrings$;
import prismparser.casestudies.DieGenerator;
import prismparser.casestudies.EglContractSigningGenerator;
import prismparser.casestudies.SyncLeaderGenerator;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.parsing.combinator.Parsers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParserTests$
extends SyntaxTreeGenerator
implements ScalaObject {
    public static final ParserTests$ MODULE$;
    private List<Tuple2<String, String>> failures;

    static {
        new ParserTests$();
    }

    public List<Tuple2<String, String>> failures() {
        return this.failures;
    }

    public void failures_$eq(List<Tuple2<String, String>> list) {
        this.failures = list;
    }

    public void test(Parsers.Parser<Object> p, StringOps in) {
        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"input : ").append((Object)in).toString());
        Parsers.ParseResult r = this.parseAll(p, Predef$.MODULE$.unaugmentString(in));
        Predef$.MODULE$.println((Object)(r.successful() ? " -- success" : " -- failure"));
        if (!r.successful()) {
            Tuple2 tuple2 = new Tuple2((Object)in.toString(), (Object)r.toString());
            this.failures_$eq((List<Tuple2<String, String>>)this.failures().$colon$colon((Object)tuple2));
        }
    }

    public void main(String[] args) {
        Predef$.MODULE$.println((Object)"--------------------------------------");
        Predef$.MODULE$.println((Object)"-----WILL NOW RUN TESTS---------------");
        Predef$.MODULE$.println((Object)"--------------------------------------");
        this.test(this.mathexpr(), Predef$.MODULE$.augmentString("2 * (3+7)"));
        this.test(this.mathexpr(), Predef$.MODULE$.augmentString("x"));
        this.test(this.mathexpr(), Predef$.MODULE$.augmentString("2 * (3+x)"));
        this.test(this.mathexpr(), Predef$.MODULE$.augmentString("-4 * x + y"));
        this.test(this.mathexpr(), Predef$.MODULE$.augmentString("3 + -x"));
        this.test(this.vardecl(), Predef$.MODULE$.augmentString("x : [0..3]"));
        this.test(this.vardecl(), Predef$.MODULE$.augmentString("x : [0..3] init 0"));
        this.test(this.vardecl(), Predef$.MODULE$.augmentString("x : bool"));
        this.test(this.vardecl(), Predef$.MODULE$.augmentString("x : bool init false"));
        this.test(this.condexpr(), Predef$.MODULE$.augmentString("2+5 < 3"));
        this.test(this.condexpr(), Predef$.MODULE$.augmentString("2+5 < 3 & 2+5 >= 3"));
        this.test(this.condexpr(), Predef$.MODULE$.augmentString("2+5 < 3 & (_x3+5 >= 3 | 2+4 <= 3)"));
        this.test(this.command(), Predef$.MODULE$.augmentString("[] x = 0-> 0.5 : (x' = 3) + 0.5 : (y'=0) & (z'=2)"));
        this.test(this.command(), Predef$.MODULE$.augmentString("[] x=0 -> 0.8:(x'=0) + 0.2:(x'=1)"));
        this.test(this.updateAssignment(), Predef$.MODULE$.augmentString("(x'=5)"));
        this.test(this.command(), Predef$.MODULE$.augmentString("[serve] x=1 & y!=2 -> (x'=2)"));
        this.test(this.command(), Predef$.MODULE$.augmentString("[] x=2 -> 0.5:(x'=2) + 0.5:(x'=0)"));
        this.test(this.command(), Predef$.MODULE$.augmentString("[] launch -> (new'=true) & (runCount'=TotalRuns) & (launch'=false)"));
        this.test(this.command(), Predef$.MODULE$.augmentString("[] !good & !bad & !deliver & run ->\n\t              goodC : (good'=true) & (recordLast'=true) & (run'=false) +\n\t               badC : (bad'=true)  & (badObserve'=true) & (run'=false)"));
        this.test(this.module(), Predef$.MODULE$.augmentString("module M1\n\n    x : [0..2] init 0;\n\n    [] x=0 -> 0.8:(x'=0) + 0.2:(x'=1);\n    [] x=1 & y!=2 -> (x'=2);\n    [] x=2 -> 0.5:(x'=2) + 0.5:(x'=0);\n\n    endmodule"));
        this.test(this.algebra(), Predef$.MODULE$.augmentString("(station1 ||| station2 ||| station3) |[serve]| server"));
        this.test(this.algebra(), Predef$.MODULE$.augmentString("((P1 |[a]| P2) / {a}) || Q"));
        this.test(this.algebra(), Predef$.MODULE$.augmentString("((P1 |[a]| P2) {a<-b}) |[b]| Q"));
        this.test(this.formula(), Predef$.MODULE$.augmentString("formula kB = ( (a1_0=L  & a2_0=L)\n             | (a1_1=L  & a2_1=L)\n             | (a1_2=L  & a2_2=L)\n             | (a1_3=L  & a2_3=L)\n             | (a1_4=L  & a2_4=L)\n             | (a1_5=L  & a2_5=L)\n             | (a1_6=L  & a2_6=L)\n             | (a1_7=L  & a2_7=L)\n             | (a1_8=L  & a2_8=L)\n             | (a1_9=L  & a2_9=L));"));
        this.test(this.program(), Predef$.MODULE$.augmentString("\n\nmodule M1\n\n    x : [0..2] init 0;\n\n    [] x=0 -> 0.8:(x'=0) + 0.2:(x'=1);\n    [] x=1 & y!=2 -> (x'=2);\n    [] x=2 -> 0.5:(x'=2) + 0.5:(x'=0);\n\nendmodule\n\nmdp\n\nmodule M2\n\n    y : [0..2] init 0;\n\n    [] y=0 -> 0.8:(y'=0) + 0.2:(y'=1);\n    [] y=1 & x!=2 -> (y'=2);\n    [] y=2 -> 0.5:(y'=2) + 0.5:(y'=0);\n\nendmodule"));
        this.test(this.program(), Predef$.MODULE$.augmentString("const int N = 10;\nconst double mu = 1/10;\nconst double lambda = 1/2;\nconst double gamma = 1/3;\n\nmodule queue\n     q : [0..N];\n\n     [] q<N -> mu:(q'=q+1);\n     [] q=N -> mu:(q'=q);\n     [serve] q>0 -> lambda:(q'=q-1);\nendmodule\n\nmodule server\n     s : [0..1];\n\n     [serve] s=0 -> 1:(s'=1);\n     [] s=1 -> gamma:(s'=0);\nendmodule"));
        this.test(this.program(), Predef$.MODULE$.augmentString(TestStrings$.MODULE$.example1()));
        this.test(this.program(), Predef$.MODULE$.augmentString(TestStrings$.MODULE$.example_module_renaming()));
        this.test(this.program(), Predef$.MODULE$.augmentString(new DieGenerator().model()));
        this.test(this.program(), Predef$.MODULE$.augmentString(new SyncLeaderGenerator().model()));
        this.test(this.program(), Predef$.MODULE$.augmentString(new EglContractSigningGenerator().model()));
        Predef$.MODULE$.println((Object)"--------------------------------------");
        Predef$.MODULE$.println((Object)"-----TESTS COMPLETE-------------------");
        Predef$.MODULE$.println((Object)"--------------------------------------");
        if (this.failures().isEmpty()) {
            Predef$.MODULE$.println((Object)"All tests successful!");
        } else {
            Predef$.MODULE$.println((Object)new StringBuilder().append(this.failures().size()).append((Object)" errors:").toString());
            this.failures_$eq((List<Tuple2<String, String>>)this.failures().reverse());
            ((LinearSeqOptimized)this.failures().filter((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<String, String> tuple2) {
                    Tuple2<String, String> tuple22 = tuple2;
                    return tuple22 != null;
                }
            })).foreach((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<String, String> tuple2) {
                    Tuple2<String, String> tuple22 = tuple2;
                    if (tuple22 != null) {
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Input: ").append(tuple22._1()).append((Object)BoxesRunTime.boxToCharacter((char)'\n')).append((Object)"Problem: ").append(tuple22._2()).toString());
                        return;
                    }
                    throw new MatchError(tuple22);
                }
            });
        }
    }

    private ParserTests$() {
        MODULE$ = this;
        this.failures = Nil$.MODULE$;
    }
}

