/*
 * Decompiled with CFR 0.152.
 */
package prismparser.casestudies;

import prismparser.casestudies.CaseStudyGenerator;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001%3A!\u0001\u0002\u0001\u000f\ty1I]8xIN<UM\\3sCR|'O\u0003\u0002\u0004\t\u0005Y1-Y:fgR,H-[3t\u0015\u0005)\u0011a\u00039sSNl\u0007/\u0019:tKJ\u001c\u0001aE\u0002\u0001\u00111\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u0003%\r\u000b7/Z*uk\u0012Lx)\u001a8fe\u0006$xN\u001d\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\u0014\u0001\t\u0015\r\u0011\"\u0001\u0015\u0003%\u0019'o\\<e'&TX-F\u0001\u0016!\tia#\u0003\u0002\u0018\u001d\t\u0019\u0011J\u001c;\t\u0011e\u0001!\u0011!Q\u0001\nU\t!b\u0019:po\u0012\u001c\u0016N_3!\u0011!Y\u0002A!b\u0001\n\u0003!\u0012!\u0003;pi\u0006d'+\u001e8t\u0011!i\u0002A!A!\u0002\u0013)\u0012A\u0003;pi\u0006d'+\u001e8tA!Aq\u0004\u0001BC\u0002\u0013\u0005\u0001%\u0001\bg_J<\u0018M\u001d3j]\u001e\u0004&o\u001c2\u0016\u0003\u0005\u0002\"!\u0004\u0012\n\u0005\rr!A\u0002#pk\ndW\r\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003\"\u0003=1wN]<be\u0012Lgn\u001a)s_\n\u0004\u0003\u0002C\u0014\u0001\u0005\u000b\u0007I\u0011\u0001\u0011\u0002\u000f\t\fG\r\u0015:pE\"A\u0011\u0006\u0001B\u0001B\u0003%\u0011%\u0001\u0005cC\u0012\u0004&o\u001c2!\u0011\u0015Y\u0003\u0001\"\u0001-\u0003\u0019a\u0014N\\5u}Q)QFL\u00181cA\u0011\u0011\u0002\u0001\u0005\u0006')\u0002\r!\u0006\u0005\u00067)\u0002\r!\u0006\u0005\u0006?)\u0002\r!\t\u0005\u0006O)\u0002\r!\t\u0005\u0006W\u0001!\ta\r\u000b\u0004[Q*\u0004\"B\n3\u0001\u0004)\u0002\"B\u000e3\u0001\u0004)\u0002\"B\u0016\u0001\t\u00039D#A\u0017\t\u000be\u0002A\u0011\u0001\u001e\u0002\u000b5|G-\u001a7\u0016\u0003m\u0002\"\u0001P!\u000e\u0003uR!AP \u0002\t1\fgn\u001a\u0006\u0002\u0001\u0006!!.\u0019<b\u0013\t\u0011UH\u0001\u0004TiJLgn\u001a\u0005\u0006\t\u0002!\t!R\u0001\taJ|\u0007/\u001a:usV\ta\tE\u0002\u000e\u000fnJ!\u0001\u0013\b\u0003\tM{W.\u001a")
public class CrowdsGenerator
extends CaseStudyGenerator
implements ScalaObject {
    private final int crowdSize;
    private final int totalRuns;
    private final double forwardingProb;
    private final double badProb;

    public int crowdSize() {
        return this.crowdSize;
    }

    public int totalRuns() {
        return this.totalRuns;
    }

    public double forwardingProb() {
        return this.forwardingProb;
    }

    public double badProb() {
        return this.badProb;
    }

    @Override
    public String model() {
        return new StringBuilder().append((Object)"// CROWDS [Reiter,Rubin]\n// Vitaly Shmatikov, 2002\n\ndtmc\n\n// Probability of forwarding\nconst double    PF = ").append((Object)BoxesRunTime.boxToDouble((double)this.forwardingProb())).append((Object)";\nconst double notPF = 0.").append((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.doubleWrapper((double)100000000 - (double)100000000 * this.forwardingProb()).round())).append((Object)";  // must be 1-PF\n\n// Probability that a crowd member is bad\nconst double  badC = ").append((Object)BoxesRunTime.boxToDouble((double)this.badProb())).append((Object)";\nconst double goodC = 0.").append((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.doubleWrapper((double)100000000 - (double)100000000 * this.badProb()).round())).append((Object)";  // must be 1-badC\n\nconst int TotalRuns = ").append((Object)BoxesRunTime.boxToInteger((int)this.totalRuns())).append((Object)"; // Total number of protocol runs to analyze\nconst int CrowdSize = ").append((Object)BoxesRunTime.boxToInteger((int)this.crowdSize())).append((Object)"; // CWDSIZ: actual number of good crowd members\n\n// Process definitions\nmodule crowds\n\n\t// Auxiliary variables\n\tlaunch:   bool init true;       // Start modeling?\n\tnew:      bool init false;      // Initialize a new protocol instance?\n\trunCount: [0..TotalRuns] init TotalRuns;   // Counts protocol instances\n\tstart:    bool init false;      // Start the protocol?\n\trun:      bool init false;      // Run the protocol?\n\tlastSeen: [0..CrowdSize] init CrowdSize;   // Last crowd member to touch msg\n\tgood:     bool init false;      // Crowd member is good?\n\tbad:      bool init false;      //              ... bad?\n\trecordLast: bool init false;    // Record last seen crowd member?\n\tbadObserve: bool init false;    // Bad members observes who sent msg?\n\tdeliver:  bool init false;      // Deliver message to destination?\n\tdone:     bool init false;      // Protocol instance finished?\n\n\t// Counters for attackers' observations\n\t// CWDMAX: 1 counter per each good crowd member\n").append((Object)((TraversableOnce)Predef$.MODULE$.intWrapper(0).until(this.crowdSize()).map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(int i) {
                return new StringBuilder().append((Object)"observe").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)":  [0..TotalRuns] init 0;").toString();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("", "\n", "\n")).append((Object)"\n\t\n\t[] launch -> (new'=true) & (runCount'=TotalRuns) & (launch'=false);\n\t// Set up a new protocol instance\n\t[] new & runCount>0 -> (runCount'=runCount-1) & (new'=false) & (start'=true);\n\t\n\t// SENDER\n\t// Start the protocol\n\t[] start -> (lastSeen'=0) & (run'=true) & (deliver'=false) & (start'=false);\n\t\n\t// CROWD MEMBERS\n\t// Good or bad crowd member?\n\t[] !good & !bad & !deliver & run ->\n\t              goodC : (good'=true) & (recordLast'=true) & (run'=false) +\n\t               badC : (bad'=true)  & (badObserve'=true) & (run'=false);\n\n\t// GOOD MEMBERS\n\t// Forward with probability PF, else deliver\n\t[] good & !deliver & run -> PF : (good'=false) + notPF : (deliver'=true);\n\t// Record the last crowd member who touched the msg;\n\t// all good members may appear with equal probability\n\t//    Note: This is backward.  In the real protocol, each honest\n\t//          forwarder randomly chooses the next forwarder.\n\t//          Here, the identity of an honest forwarder is randomly\n\t//          chosen *after* it has forwarded the message.\n\n    [] recordLast ->\n").append((Object)((TraversableOnce)Predef$.MODULE$.intWrapper(0).until(this.crowdSize() - 1).map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final CrowdsGenerator $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(int i) {
                return new StringBuilder().append((Object)"\t        1/").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.crowdSize())).append((Object)" : (lastSeen'=").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)") & (recordLast'=false) & (run'=true) +").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("", "\n", "\n")).append((Object)"\t        1/").append((Object)BoxesRunTime.boxToInteger((int)this.crowdSize())).append((Object)" : (lastSeen'=").append((Object)BoxesRunTime.boxToInteger((int)(this.crowdSize() - 1))).append((Object)") & (recordLast'=false) & (run'=true);\n").append((Object)"// BAD MEMBERS\n\t// Remember from whom the message was received and deliver\n\t// CWDMAX: 1 rule per each good crowd member\n").append((Object)((TraversableOnce)Predef$.MODULE$.intWrapper(0).until(this.crowdSize()).map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(int i) {
                return new StringBuilder().append((Object)"[] lastSeen=").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)" & badObserve & observe").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)" < TotalRuns -> ").append((Object)" (observe").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)"' =observe").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)" +1) & (deliver'=true) & (run'=true) & (badObserve'=false);").toString();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("", "\n", "\n")).append((Object)"\n\t// RECIPIENT\n\t// Delivery to destination\n\t[] deliver & run -> (done'=true) & (deliver'=false) & (run'=false) & (good'=false) & (bad'=false);\n\t// Start a new instance\n\t[] done -> (new'=true) & (done'=false) & (run'=false) & (lastSeen'=CrowdSize);\n\t\nendmodule").toString();
    }

    public Some<String> property() {
        return new Some((Object)"observe0>1");
    }

    public CrowdsGenerator(int crowdSize, int totalRuns, double forwardingProb, double badProb) {
        this.crowdSize = crowdSize;
        this.totalRuns = totalRuns;
        this.forwardingProb = forwardingProb;
        this.badProb = badProb;
        Predef$.MODULE$.assert(crowdSize > 0);
        Predef$.MODULE$.assert(totalRuns > 0);
        Predef$.MODULE$.assert(forwardingProb > 0.0 & forwardingProb < 1.0);
        Predef$.MODULE$.assert(badProb > 0.0 & badProb < 1.0);
    }

    public CrowdsGenerator(int crowdSize, int totalRuns) {
        this(crowdSize, totalRuns, 0.8, 0.167);
    }

    public CrowdsGenerator() {
        this(2, 2);
    }
}

