/*
 * Decompiled with CFR 0.152.
 */
package prismparser.casestudies;

import prismparser.casestudies.CaseStudyGenerator;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001=2A!\u0001\u0002\u0001\u000f\tYRi\u001a7D_:$(/Y2u'&<g.\u001b8h\u000f\u0016tWM]1u_JT!a\u0001\u0003\u0002\u0017\r\f7/Z:uk\u0012LWm\u001d\u0006\u0002\u000b\u0005Y\u0001O]5t[B\f'o]3s\u0007\u0001\u00192\u0001\u0001\u0005\r!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\nDCN,7\u000b^;es\u001e+g.\u001a:bi>\u0014\bCA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!aC*dC2\fwJ\u00196fGRD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0002\u001dB\u0011Q\"F\u0005\u0003-9\u00111!\u00138u\u0011\u0015A\u0002\u0001\"\u0001\u001a\u0003\u0019a\u0014N\\5u}Q\u0011!d\u0007\t\u0003\u0013\u0001AQaE\fA\u0002QAQ\u0001\u0007\u0001\u0005\u0002u!\u0012A\u0007\u0005\u0006?\u0001!\t\u0001I\u0001\u0006[>$W\r\u001c\u000b\u0002CA\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0005Y\u0006twMC\u0001'\u0003\u0011Q\u0017M^1\n\u0005!\u001a#AB*ue&tw\rC\u0003+\u0001\u0011\u00051&\u0001\u0005qe>\u0004XM\u001d;z+\u0005a\u0003cA\u0007.C%\u0011aF\u0004\u0002\u0005'>lW\r")
public class EglContractSigningGenerator
extends CaseStudyGenerator
implements ScalaObject {
    private final int N;

    @Override
    public String model() {
        return new StringBuilder().append((Object)"// Randomised protocol for signing contracts taken from:\n// S. Even, O. Goldreich, and A. Lempel.\n// A randomized protocol for signing contracts.\n// Communications of the ACM, 28(6):637 647, 1985.\n\n//-----------------------------------------------------------------------------------------\n\ndtmc // Model is a DTMC (no nondeterminism)\n\n// CONSTANTS:\n\n// N: number of pairs of secrets each party sends\nconst int N=").append((Object)BoxesRunTime.boxToInteger((int)this.N)).append((Object)";\n// L: number of bits in each secret (fix at 2)\nconst int L=2;\n\n// FORMULAE:\n\n// B knows a pair of secrets\nformula kB = ( (a1_0=L  & a2_0=L)\n             | (a1_1=L  & a2_1=L)\n             | (a1_2=L  & a2_2=L)\n             | (a1_3=L  & a2_3=L)\n             | (a1_4=L  & a2_4=L)\n             | (a1_5=L  & a2_5=L)\n             | (a1_6=L  & a2_6=L)\n             | (a1_7=L  & a2_7=L)\n             | (a1_8=L  & a2_8=L)\n             | (a1_9=L  & a2_9=L));\n// A knows a pair of secrets\nformula kA = ( (b1_0=L  & b2_0=L)\n             | (b1_1=L  & b2_1=L)\n             | (b1_2=L  & b2_2=L)\n             | (b1_3=L  & b2_3=L)\n             | (b1_4=L  & b2_4=L)\n             | (b1_5=L  & b2_5=L)\n             | (b1_6=L  & b2_6=L)\n             | (b1_7=L  & b2_7=L)\n             | (b1_8=L  & b2_8=L)\n             | (b1_9=L  & b2_9=L));\n\n//----------------------------------------------------------------------------------------\n\n// Scheduler: used to order the sending of messages between parties A and B\n\nmodule scheduler\n\t\n\t// b: which bit of the secret a party should send next\n\tb : [1..L];\n\t// n: which secret a party should send next\n\tn : [0..max(N-1,1)];\n\t// phase: current phase of the protocol\n\t//        1   = sending messages of the form OT(.,.,.,.)\n\t//        2&3 = sending secrets 1..N and N+1..2N, respectively\n\t//        4   = finished\n\tphase : [1..5];\n\t// party: which party moves next\n\tparty : [1..2];\n\t\n\t// FIRST PHASE:\n\t\n\t// A sends a message, B will go next\n\t[receiveB] phase=1 & party=1 -> (party'=2);\n\t// B sends a message, move onto next message and go back to A\n\t[receiveA] phase=1 & party=2 & n<N-1 -> (party'=1) & (n'=n+1);\n\t// B sends final (Nth) message, move to next phase\n\t[receiveA] phase=1 & party=2 & n=N-1 -> (party'=1) & (phase'=2) & (n'=0); \n\t\n\t// SECOND AND THIRD PHASES (interleaved for A and B):\n\t\n\t// A sends bth bit of nth secret (for  n=1..N-1), move to next secret\n\t[receiveB] phase=2 & party=1 & n<N-1-> (n'=n+1);\n\t// A sends bth bit of Nth secret, move to next phase (N+1..2N)\n\t[receiveB] phase=2 & party=1 & n=N-1 -> (phase'=3) & (n'=0); \n\t// A sends bth bit of (N+n)th secret (for  n=1..N-1), move to next secret\n\t[receiveB] phase=3 & party=1 & n<N-1-> (n'=n+1);\n\t// A sends bth bit of last (2Nth) secret, B will go next\n\t[receiveB] phase=3 & party=1 & n=N-1 -> (phase'=2) & (party'=2) & (n'=0);\n\t\n\t// B sends bth bit of nth secret (for  n=1..N-1), move to next secret\n\t[receiveA] phase=2 & party=2 & n<N-1 -> (n'=n+1);\n\t// B sends bth bit of Nth secret, move to next phase (N+1..2N)\n\t[receiveA] phase=2 & party=2 & n=N-1 -> (phase'=3) & (n'=0);\n\t// B sends bth bit of (N+n)th secret (for  n=1..N-1), move to next secret\n\t[receiveA] phase=3 & party=2 & n<N-1 -> (n'=n+1);\n\t// B sends bth bit of last (2Nth) secret, increment b and go back to A\n\t[receiveA] phase=3 & party=2 & n=N-1 & b<L -> (phase'=2) & (party'=1) & (n'=0) & (b'=b+1);\n\t// B sends final (Lth) bit of last (2Nth) secret, protocol is now finished\n\t[receiveA] phase=3 & party=2 & n=N-1 & b=L -> (phase'=4);\n\t\n\t// FINISHED (loop)\n\t[] phase=4 -> (phase'=4);\n\t\nendmodule\n\n//-----------------------------------------------------------------------------------------\n\n// Party A\n\nmodule partyA\n\t\n\t// How many bits of each of B's secrets A currently knows\n\t// Secrets are in pairs and thus divided into two sets.\n\t// b1_i stores the value (number of bits known) for the ith secret\n\t// of the first set of secrets. b2_i stores the value\n\t// for the ith secret of the second set of secrets.\n\t// (Technical note: Keep pairs of secrets together\n\t//  to give a more structured model and hence smaller MTBDD)\n\tb1_0 : [0..L]; b2_0 : [0..L];\n\tb1_1 : [0..L]; b2_1 : [0..L];\n\tb1_2 : [0..L]; b2_2 : [0..L];\n\tb1_3 : [0..L]; b2_3 : [0..L];\n\tb1_4 : [0..L]; b2_4 : [0..L];\n\tb1_5 : [0..L]; b2_5 : [0..L];\n\tb1_6 : [0..L]; b2_6 : [0..L];\n\tb1_7 : [0..L]; b2_7 : [0..L];\n\tb1_8 : [0..L]; b2_8 : [0..L];\n\tb1_9 : [0..L]; b2_9 : [0..L];\n\t\n\t// A receives either secret n-1 or N+(n-1) with equal probability\n\t// (using Oblivious Transfer (OT) protocol)\n\t// Note: get full secret here, i.e. all L bits\n\t[receiveA] phase=1 & n=0  -> 0.5 : (b1_0'=L) + 0.5 : (b2_0'=L);\n\t[receiveA] phase=1 & n=1  -> 0.5 : (b1_1'=L) + 0.5 : (b2_1'=L);\n\t[receiveA] phase=1 & n=2  -> 0.5 : (b1_2'=L) + 0.5 : (b2_2'=L);\n\t[receiveA] phase=1 & n=3  -> 0.5 : (b1_3'=L) + 0.5 : (b2_3'=L);\n\t[receiveA] phase=1 & n=4  -> 0.5 : (b1_4'=L) + 0.5 : (b2_4'=L);\n\t[receiveA] phase=1 & n=5  -> 0.5 : (b1_5'=L) + 0.5 : (b2_5'=L);\n\t[receiveA] phase=1 & n=6  -> 0.5 : (b1_6'=L) + 0.5 : (b2_6'=L);\n\t[receiveA] phase=1 & n=7  -> 0.5 : (b1_7'=L) + 0.5 : (b2_7'=L);\n\t[receiveA] phase=1 & n=8  -> 0.5 : (b1_8'=L) + 0.5 : (b2_8'=L);\n\t[receiveA] phase=1 & n=9  -> 0.5 : (b1_9'=L) + 0.5 : (b2_9'=L);\n\t// A receives single bit for secrets 0..N-1 (when scheduler module in phase 2)\n\t[receiveA] phase=2 & n=0  -> (b1_0'=min(b1_0+1,L));\n\t[receiveA] phase=2 & n=1  -> (b1_1'=min(b1_1+1,L));\n\t[receiveA] phase=2 & n=2  -> (b1_2'=min(b1_2+1,L));\n\t[receiveA] phase=2 & n=3  -> (b1_3'=min(b1_3+1,L));\n\t[receiveA] phase=2 & n=4  -> (b1_4'=min(b1_4+1,L));\n\t[receiveA] phase=2 & n=5  -> (b1_5'=min(b1_5+1,L));\n\t[receiveA] phase=2 & n=6  -> (b1_6'=min(b1_6+1,L));\n\t[receiveA] phase=2 & n=7  -> (b1_7'=min(b1_7+1,L));\n\t[receiveA] phase=2 & n=8  -> (b1_8'=min(b1_8+1,L));\n\t[receiveA] phase=2 & n=9  -> (b1_9'=min(b1_9+1,L));\n\t// A receives single bits for secrets N..2N-1 (when scheduler module in phase 3)\n\t[receiveA] phase=3 & n=0  -> (b2_0'=min(b2_0+1,L));\n\t[receiveA] phase=3 & n=1  -> (b2_1'=min(b2_1+1,L));\n\t[receiveA] phase=3 & n=2  -> (b2_2'=min(b2_2+1,L));\n\t[receiveA] phase=3 & n=3  -> (b2_3'=min(b2_3+1,L));\n\t[receiveA] phase=3 & n=4  -> (b2_4'=min(b2_4+1,L));\n\t[receiveA] phase=3 & n=5  -> (b2_5'=min(b2_5+1,L));\n\t[receiveA] phase=3 & n=6  -> (b2_6'=min(b2_6+1,L));\n\t[receiveA] phase=3 & n=7  -> (b2_7'=min(b2_7+1,L));\n\t[receiveA] phase=3 & n=8  -> (b2_8'=min(b2_8+1,L));\n\t[receiveA] phase=3 & n=9  -> (b2_9'=min(b2_9+1,L));\n\nendmodule\n\n//-----------------------------------------------------------------------------------------\n\n// Construct module for party B through renaming\n\nmodule partyB=partyA[b1_0=a1_0 ,b1_1=a1_1 ,b1_2=a1_2 ,b1_3=a1_3 ,b1_4=a1_4 ,b1_5=a1_5 ,b1_6=a1_6 ,b1_7=a1_7 ,b1_8=a1_8 ,b1_9=a1_9,\n                     b2_0=a2_0 ,b2_1=a2_1 ,b2_2=a2_2 ,b2_3=a2_3 ,b2_4=a2_4 ,b2_5=a2_5 ,b2_6=a2_6 ,b2_7=a2_7 ,b2_8=a2_8 ,b2_9=a2_9,\n                     receiveA=receiveB] \nendmodule").toString();
    }

    public Some<String> property() {
        return new Some((Object)"phase=4");
    }

    public EglContractSigningGenerator(int N) {
        this.N = N;
        Predef$.MODULE$.assert(N > 0 && N <= 10);
    }

    public EglContractSigningGenerator() {
        this(4);
    }
}

