/*
 * Decompiled with CFR 0.152.
 */
package comics;

import comics.data.Config;
import comics.data.CounterExampleResult;
import comics.data.CounterExampleSearchParameters;
import comics.data.ModelCheckResult;
import comics.graph.data.Labels;
import comics.graph.data.MarkovChain;
import comics.graph.data.Node;
import comics.gui.GUI;
import comics.gui.ParsingProgress;
import comics.io.ExtensionType;
import comics.io.FileHandler;
import comics.io.input.ConfReader;
import comics.io.input.DtmcReader;
import comics.io.input.InputParser;
import comics.io.input.LabReader;
import comics.io.input.PrismReader;
import comics.io.input.TraReader;
import comics.io.input.XmlParser;
import comics.io.output.DtmcWriter;
import comics.io.output.LabWriter;
import comics.io.output.OutputFormatter;
import comics.io.output.TraWriter;
import comics.io.output.XmlWriter;
import comics.utilities.Output;
import comics.utilities.Pair;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class SCC_MC {
    private MarkovChain markovChain;
    private GUI gui = new GUI(this);
    private FileHandler fileHandler = new FileHandler();
    private boolean graphLocked = false;
    private ModelCheckResult modelCheckResult;
    public CounterExampleSearchParameters counterExampleSearchParameters;
    public CounterExampleResult counterExampleResult;
    private static SCC_MC instance = null;

    private SCC_MC() {
        this.unlockGraph();
        this.resetMarkovChain();
    }

    public static SCC_MC getInstance() {
        if (instance == null) {
            instance = new SCC_MC();
        }
        return instance;
    }

    public GUI getGui() {
        return this.gui;
    }

    public ModelCheckResult getModelCheckResult() {
        return this.modelCheckResult;
    }

    public void setModelCheckResult(ModelCheckResult modelCheckResult) {
        this.modelCheckResult = modelCheckResult;
        if (this.modelCheckResult != null && this.modelCheckResult.getProbability() > 0.0) {
            this.gui.getToolbar().getToolbarCounterExample().enableCounterExampleSearch();
        }
    }

    public CounterExampleSearchParameters getCounterExampleSearchParameters() {
        return this.counterExampleSearchParameters;
    }

    public void unlockGraph() {
        this.graphLocked = false;
        this.counterExampleResult = null;
        this.modelCheckResult = null;
        this.counterExampleSearchParameters = null;
        this.gui.getToolbar().getToolbarCounterExample().reset();
        this.gui.getToolbar().getToolbarEdit().makeEnabled(true);
        this.gui.wrapper.lockGraph(false);
    }

    public void lockGraph() {
        this.graphLocked = true;
        this.gui.getToolbar().getToolbarEdit().makeEnabled(false);
        this.gui.wrapper.lockGraph(true);
    }

    public boolean isGraphLocked() {
        return this.graphLocked;
    }

    public void executeParser(InputParser inputParser) {
        ParsingProgress parsingProgress = new ParsingProgress(GUI.getFrame(), inputParser);
        long l = System.currentTimeMillis();
        boolean bl = parsingProgress.run();
        long l2 = System.currentTimeMillis();
        Output.print("Parsing took " + (l2 - l) + "ms");
        if (bl) {
            if (inputParser instanceof ConfReader) {
                parsingProgress.destroy();
                return;
            }
            if (inputParser.getFile() != null) {
                Config.filename = inputParser.getFile().getName();
            }
            this.gui.wrapper.lockGraph(false);
            this.resetMarkovChain();
            this.markovChain = inputParser.getParseResult();
            boolean bl2 = true;
            int n = this.markovChain.isReduced() ? this.markovChain.getNumberOfReducedEdges() : this.markovChain.getNumberOfEdges();
            if (n > Config.edgeCountVisible) {
                String string = "The graph has " + n + " edges." + Output.getLineBreak() + "This might cause problems while displaying." + Output.getLineBreak() + "Would you like to display the graph anyhow?";
                bl2 = GUI.showYesNoQuestion("Show graph?", string);
            }
            if (bl2) {
                this.gui.wrapper.setGraphEnabled(true);
                this.gui.wrapper.setMarkovChain(this.markovChain);
            } else {
                this.gui.wrapper.setGraphEnabled(false);
                this.gui.getOutputPanel().loadMarkovChain();
            }
            this.gui.wrapper.lockGraph(this.isGraphLocked());
            parsingProgress.destroy();
        } else {
            parsingProgress.destroy();
            GUI.showMessage("File couldn't be loaded", "Error while loading", 0);
        }
    }

    public void openMarkovChainFile() {
        this.unlockGraph();
        ExtensionType[] extensionTypeArray = new ExtensionType[]{ExtensionType.TRA, ExtensionType.XML, ExtensionType.DTMC, ExtensionType.CONF};
        File file = this.fileHandler.getOpenFile(extensionTypeArray);
        if (file == null) {
            return;
        }
        this.handleInputFile(file);
    }

    public void handleInputFile(File file) {
        switch (ExtensionType.getFileExtension(file)) {
            case TRA: {
                try {
                    TraReader traReader = new TraReader(file);
                    this.executeParser(traReader);
                    this.gui.setLoadLabItemEnabled(true);
                    boolean bl = GUI.showYesNoQuestion("Load labels?", "Do you want to load a file containing labels?");
                    if (!bl) break;
                    this.readLab();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case DTMC: {
                try {
                    DtmcReader dtmcReader = new DtmcReader(file);
                    this.executeParser(dtmcReader);
                    this.gui.setLoadLabItemEnabled(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case CONF: {
                try {
                    this.counterExampleSearchParameters = new CounterExampleSearchParameters();
                    ConfReader confReader = new ConfReader(file, this.counterExampleSearchParameters);
                    this.executeParser(confReader);
                    if (Config.filename.isEmpty()) {
                        Output.print("DTMC File: not specified");
                    }
                    File file2 = new File(Config.path, Config.filename);
                    this.handleInputFile(file2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case XML: {
                this.handleXML(file);
                this.gui.setLoadLabItemEnabled(true);
                break;
            }
            case LAB: {
                this.handleLab(file);
            }
        }
    }

    public void handleXML(File file) {
        if (file == null) {
            return;
        }
        this.handleXMLString(FileHandler.fileContentToString(file));
    }

    public void handleXMLString(String string) {
        XmlParser xmlParser = new XmlParser(string);
        this.executeParser(xmlParser);
        FileHandler.StringToFileContent(this.markovChain.toString(), new File("parse_result.txt"));
    }

    public void handlePrism(File file) {
        if (file == null) {
            return;
        }
        PrismReader prismReader = new PrismReader(file);
        this.executeParser(prismReader);
    }

    public void readLab() {
        File file = this.fileHandler.getOpenFile(ExtensionType.LAB);
        this.handleLab(file);
    }

    public void handleLab(File file) {
        if (file == null) {
            return;
        }
        LabReader labReader = new LabReader(file);
        labReader.parse();
        for (String object : labReader.declarationList) {
            this.markovChain.addLabel(object);
        }
        for (Pair pair : labReader.nodeList) {
            Node node = this.markovChain.getNodeByIntName((Integer)pair.getLeft());
            this.markovChain.addLabelNode(node, (String)pair.getRight());
        }
        this.chooseLabelTarget();
        boolean bl = GUI.showYesNoQuestion("Set initial label?", "Do you want to set an initial label?");
        if (bl) {
            this.chooseLabelInitial();
        }
    }

    public void chooseLabelTarget() {
        Labels labels = GUI.showLabelList(this.markovChain.getLabels(), "Choose one or more labels for target states");
        for (String string : labels) {
            this.markovChain.setTargetLabel(string);
        }
        this.gui.getOutputPanel().clear();
        this.gui.getOutputPanel().loadMarkovChain();
        this.gui.wrapper.updateDisplayedGraph();
    }

    public void chooseLabelInitial() {
        Object[] objectArray = this.markovChain.getLabels().toArray();
        String string = (String)JOptionPane.showInputDialog(GUI.getFrame(), "Choose one label for the intial state", "Input label", -1, null, objectArray, null);
        ArrayList<Node> arrayList = this.markovChain.getNodesForLabel(string);
        Object object = JOptionPane.showInputDialog(GUI.getFrame(), "Select unique input node", "Select unique input node", -1, null, arrayList.toArray(), "");
        Node node = (Node)object;
        this.chooseInitialNode(node);
    }

    public void resetMarkovChain() {
        this.markovChain = new MarkovChain();
        this.gui.wrapper.setMarkovChain(this.markovChain);
        this.gui.setLoadLabItemEnabled(false);
        this.gui.resetHide();
        this.gui.getOutputPanel().clear();
    }

    public void export(ExtensionType extensionType) {
        if (this.markovChain == null) {
            GUI.showWarningMessage("There is no Markov Chain!");
            return;
        }
        File file = this.fileHandler.getSaveFile(extensionType, null);
        if (file == null) {
            return;
        }
        OutputFormatter outputFormatter = null;
        switch (extensionType) {
            case DTMC: {
                if (this.markovChain.getInitialNode() == null) {
                    GUI.showWarningMessage("An initial node needs to be defined!");
                    break;
                }
                if (this.markovChain.getTargetNodes().isEmpty()) {
                    GUI.showWarningMessage("At least one target node needs to be defined!");
                    break;
                }
                outputFormatter = new DtmcWriter(this.markovChain, file);
                break;
            }
            case TRA: {
                outputFormatter = new TraWriter(this.markovChain, file);
                break;
            }
            case LAB: {
                outputFormatter = new LabWriter(this.markovChain, file);
                break;
            }
            case XML: {
                double d = 0.0;
                if (this.modelCheckResult != null) {
                    d = this.modelCheckResult.getProbability();
                }
                outputFormatter = new XmlWriter(this.markovChain, file, true, d);
            }
        }
        if (outputFormatter != null && outputFormatter.write()) {
            GUI.showMessage("File successfully written", "Save successfull", 1);
        } else {
            GUI.showErrorMessage("Couldn't write file");
        }
    }

    public void chooseInitialNode(Node node) {
        if (node == null) {
            return;
        }
        this.markovChain.setInitialNode(node);
        this.gui.getOutputPanel().getTabNodes().changeNode(node);
        this.gui.wrapper.updateDisplayedGraph();
    }

    public void toggleTargetState(Node node) {
        if (node == null) {
            return;
        }
        this.markovChain.setTargetNode(node, !node.isTarget());
        if (node.isTarget()) {
            this.gui.getOutputPanel().getTabTargetNodes().removeNode(node);
        } else {
            this.gui.getOutputPanel().getTabTargetNodes().addNode(node);
        }
        this.gui.getOutputPanel().getTabNodes().changeNode(node);
        this.gui.wrapper.updateDisplayedGraph();
    }

    public boolean isMarkovChainConsistent() {
        for (Node node : this.markovChain.getNodes()) {
            if (node.isConsistent()) continue;
            Output.print("Error node:" + node.getNumber());
            return false;
        }
        return true;
    }

    public MarkovChain getMarkovChain() {
        return this.markovChain;
    }

    public int getMaxNode() {
        return this.markovChain.getNumberOfNodes();
    }

    public void searchNode(int n, boolean bl) {
        Node node = this.markovChain.getNodeByIntName(n);
        this.gui.wrapper.setSelectedNode(node, true);
        if (bl) {
            this.gui.wrapper.centerNode(node);
        }
    }

    public void openLink() {
        try {
            String string = Config.url;
            Desktop.getDesktop().browse(URI.create(string));
        }
        catch (IOException iOException) {
            Output.print(iOException.getMessage());
        }
    }

    public void openManual() {
        try {
            File file = new File(Config.pathToManualPDF);
            if (file.exists()) {
                if (Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().open(file);
                } else {
                    Output.print("Awt Desktop is not supported!");
                }
            } else {
                Output.print("File does not exist!");
            }
            Output.print("Done");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void terminate() {
        this.unlockGraph();
        GUI.getFrame().dispose();
        Output.print("... and they lived happily ever after.");
    }
}

