/*
 * Decompiled with CFR 0.152.
 */
package comics.gui;

import comics.graph.gui.GraphWrapper;
import comics.gui.EditMode;
import comics.gui.GUI;
import comics.gui.NoneSelectedButtonGroup;
import comics.gui.actions.GraphKeyHandle;
import comics.gui.actions.ToolbarKeyListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class ToolbarEdit
extends JToolBar
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private GUI gui;
    private NoneSelectedButtonGroup group = new NoneSelectedButtonGroup();

    public ToolbarEdit(GUI gUI) {
        this.gui = gUI;
        this.setFloatable(false);
        this.setRollover(true);
        this.initButtons();
        Enumeration<AbstractButton> enumeration = this.group.getElements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().addKeyListener(new ToolbarKeyListener());
        }
        new GraphKeyHandle(gUI);
    }

    private void initButtons() {
        JToggleButton jToggleButton = new JToggleButton("Add State");
        jToggleButton.setVerticalTextPosition(0);
        jToggleButton.setHorizontalTextPosition(10);
        jToggleButton.setMnemonic(78);
        jToggleButton.setActionCommand("addNode");
        jToggleButton.addActionListener(this);
        this.add(jToggleButton);
        this.group.add(jToggleButton);
        jToggleButton = new JToggleButton("Add Edge");
        jToggleButton.setVerticalTextPosition(0);
        jToggleButton.setHorizontalTextPosition(10);
        jToggleButton.setMnemonic(69);
        jToggleButton.setActionCommand("addEdge");
        jToggleButton.addActionListener(this);
        this.add(jToggleButton);
        this.group.add(jToggleButton);
        jToggleButton = new JToggleButton("Delete Selected");
        jToggleButton.setVerticalTextPosition(0);
        jToggleButton.setHorizontalTextPosition(10);
        jToggleButton.setMnemonic(68);
        jToggleButton.setActionCommand("deleteSelected");
        jToggleButton.addActionListener(this);
        this.add(jToggleButton);
        this.group.add(jToggleButton);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ButtonModel buttonModel = this.group.getSelection();
        GraphWrapper graphWrapper = this.gui.wrapper;
        this.clear();
        if (buttonModel == null) {
            this.group.clearSelection();
        } else if (buttonModel.getActionCommand().equals("addNode")) {
            this.gui.setStatusBarMessage("Click to add states...");
            graphWrapper.setEditMode(EditMode.ADD_NODE);
            graphWrapper.getGraphComponent().getGraph().setCellsMovable(false);
        } else if (buttonModel.getActionCommand().equals("addEdge")) {
            this.gui.setStatusBarMessage("Choose source state...");
            graphWrapper.setEditMode(EditMode.ADD_EDGE);
            graphWrapper.getGraphComponent().setConnectable(true);
            graphWrapper.getGraphComponent().getGraph().setCellsMovable(false);
        } else if (buttonModel.getActionCommand().equals("deleteSelected")) {
            if (graphWrapper.isSelectionEmpty()) {
                this.gui.setStatusBarMessage("Selection is empty!");
            } else {
                graphWrapper.deleteSelectedNodes();
            }
            this.group.clearSelection();
        }
    }

    public void reset() {
        this.group.clearSelection();
        this.clear();
    }

    private void clear() {
        this.gui.setStatusBarMessage("");
        this.gui.wrapper.setEditMode(EditMode.NONE);
        this.gui.wrapper.getGraphMouseListener().resetState();
        this.gui.wrapper.getGraphComponent().setConnectable(false);
        this.gui.wrapper.getGraphComponent().getGraph().setCellsMovable(true);
    }

    public void makeEnabled(boolean bl) {
        this.reset();
        this.setEnabled(bl);
        Enumeration<AbstractButton> enumeration = this.group.getElements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setEnabled(bl);
        }
    }
}

