/*
 * Decompiled with CFR 0.152.
 */
package comics.gui.actions;

import com.mxgraph.model.mxCell;
import comics.SCC_MC;
import comics.graph.data.Edge;
import comics.graph.data.Node;
import comics.gui.EditMode;
import comics.gui.GUI;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class GraphMouseListener
extends MouseAdapter
implements MouseWheelListener {
    Node src = null;
    private final int STATE_SRC = 1;
    private final int STATE_TRG = 2;
    private int state = 1;

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        GUI gUI = SCC_MC.getInstance().getGui();
        Node node = gUI.wrapper.getSelectedNode();
        Edge edge = gUI.wrapper.getSelectedEdge();
        if (mouseEvent.getModifiers() == 4) {
            if (node != null) {
                gUI.getContextMenu().show(mouseEvent, node);
            } else if (edge != null) {
                gUI.getContextMenu().show(mouseEvent, edge);
            }
        } else if (gUI.wrapper.getEditMode() == EditMode.ADD_NODE) {
            if (mouseEvent.getModifiers() == 16 && gUI.wrapper.getEditMode() == EditMode.ADD_NODE) {
                gUI.wrapper.addNodeCell(mouseEvent.getX() - 20, mouseEvent.getY() - 20);
            }
        } else if (gUI.wrapper.getEditMode() == EditMode.ADD_EDGE) {
            if (gUI.wrapper.isSelectionEmpty() || gUI.wrapper.getSelectedNode() == null) {
                gUI.setStatusBarMessage("No node selected");
                return;
            }
            if (mouseEvent.getButton() == 1 && this.state == 1) {
                this.src = gUI.wrapper.getSelectedNode();
                if (this.src != null) {
                    gUI.setStatusBarMessage("Choose target node...");
                    this.state = 2;
                }
            } else if (this.state == 2 && mouseEvent.getButton() == 1 && this.completeEdge()) {
                gUI.setStatusBarMessage("Choose source node...");
                this.state = 1;
            }
        }
    }

    private boolean completeEdge() {
        GUI gUI = SCC_MC.getInstance().getGui();
        Node node = gUI.wrapper.getSelectedNode();
        if (node == null) {
            return false;
        }
        gUI.wrapper.addEdgeCell(this.src.getGraphCell(), node.getGraphCell());
        return true;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        GUI gUI = SCC_MC.getInstance().getGui();
        mxCell mxCell2 = null;
        int n = mouseWheelEvent.getWheelRotation();
        if (n > 0) {
            mxCell2 = gUI.wrapper.getCellUnderMouse(mouseWheelEvent);
            gUI.wrapper.rescaleByFactor(0.7692307692307692);
        } else {
            mxCell2 = gUI.wrapper.getCellUnderMouse(mouseWheelEvent);
            gUI.wrapper.rescaleByFactor(1.3);
        }
        gUI.wrapper.centerCell(mxCell2);
    }

    public void resetState() {
        this.state = 1;
    }
}

