/*
 * Decompiled with CFR 0.152.
 */
package comics.gui.counterexample;

import comics.SCC_MC;
import comics.data.CounterExampleSearchParameters;
import comics.gui.GUI;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class CounterExampleInitDialog {
    private ButtonGroup abstractButtonGroup = new ButtonGroup();
    private ButtonGroup globalButtonGroup = new ButtonGroup();
    private ButtonGroup closureButtonGroup = new ButtonGroup();
    private JRadioButton abstractButton;
    private JRadioButton concreteButton;
    private JRadioButton globalButton;
    private JRadioButton localButton;
    private JRadioButton closureButton;
    private JRadioButton pathsumButton;
    private JPanel abstractPanel = new JPanel();
    private JPanel abstractGroupPanel = new JPanel();
    private JPanel globalPanel = new JPanel();
    private JPanel globalGroupPanel = new JPanel();
    private JPanel closurePanel = new JPanel();
    private JPanel closureGroupPanel = new JPanel();

    public boolean show(CounterExampleSearchParameters counterExampleSearchParameters) {
        this.abstractGroupPanel.setLayout(new GridLayout(1, 2));
        JLabel jLabel = new JLabel("Abstract or concrete search algorithm?");
        this.abstractButton = new JRadioButton("Abstract");
        this.abstractButton.setActionCommand("abstract");
        this.abstractButtonGroup.add(this.abstractButton);
        this.abstractGroupPanel.add(this.abstractButton);
        this.concreteButton = new JRadioButton("Concrete");
        this.concreteButton.setActionCommand("concrete");
        this.abstractButtonGroup.add(this.concreteButton);
        this.abstractGroupPanel.add(this.concreteButton);
        if (counterExampleSearchParameters.isAbstractSearch()) {
            this.abstractButton.setSelected(true);
        } else {
            this.concreteButton.setSelected(true);
        }
        this.abstractPanel.setLayout(new GridLayout(2, 1));
        this.abstractPanel.add(jLabel);
        this.abstractPanel.add(this.abstractGroupPanel);
        this.globalGroupPanel.setLayout(new GridLayout(1, 2));
        JLabel jLabel2 = new JLabel("Global or local path search?");
        this.globalButton = new JRadioButton("Global");
        this.globalButton.setActionCommand("global");
        this.globalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CounterExampleInitDialog.this.closureGroupPanel.setEnabled(true);
                CounterExampleInitDialog.this.closurePanel.setEnabled(true);
                CounterExampleInitDialog.this.closureButton.setEnabled(true);
                CounterExampleInitDialog.this.pathsumButton.setEnabled(true);
            }
        });
        this.globalButtonGroup.add(this.globalButton);
        this.globalGroupPanel.add(this.globalButton);
        this.localButton = new JRadioButton("Local");
        this.localButton.setActionCommand("local");
        this.localButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CounterExampleInitDialog.this.closureGroupPanel.setEnabled(false);
                CounterExampleInitDialog.this.closurePanel.setEnabled(false);
                CounterExampleInitDialog.this.closureButton.setEnabled(false);
                CounterExampleInitDialog.this.pathsumButton.setEnabled(false);
                CounterExampleInitDialog.this.closureButton.setSelected(true);
                SCC_MC.getInstance().getGui().setStatusBarMessage("Can't use pathsum criterion for local search, because only path fragments are computed. Will use closures instead.");
            }
        });
        this.globalButtonGroup.add(this.localButton);
        this.globalGroupPanel.add(this.localButton);
        if (counterExampleSearchParameters.isGlobalSearch()) {
            this.globalButton.setSelected(true);
        } else {
            this.localButton.setSelected(true);
        }
        this.globalPanel.setLayout(new GridLayout(2, 1));
        this.globalPanel.add(jLabel2);
        this.globalPanel.add(this.globalGroupPanel);
        this.closureGroupPanel.setLayout(new GridLayout(1, 2));
        JLabel jLabel3 = new JLabel("Subsystem- or path-based counterexample?");
        this.closureButton = new JRadioButton("Subsystem");
        this.closureButton.setSelected(true);
        this.closureButton.setActionCommand("closure");
        this.closureButtonGroup.add(this.closureButton);
        this.closureGroupPanel.add(this.closureButton);
        this.pathsumButton = new JRadioButton("Pathset");
        this.pathsumButton.setActionCommand("pathsum");
        this.closureButtonGroup.add(this.pathsumButton);
        this.closureGroupPanel.add(this.pathsumButton);
        if (counterExampleSearchParameters.isClosure()) {
            this.closureButton.setSelected(true);
        } else {
            this.pathsumButton.setSelected(true);
        }
        this.closurePanel.setLayout(new GridLayout(2, 1));
        this.closurePanel.add(jLabel3);
        this.closurePanel.add(this.closureGroupPanel);
        Object[] objectArray = new Object[]{this.abstractPanel, this.globalPanel, this.closurePanel};
        JOptionPane jOptionPane = new JOptionPane(objectArray, 3, 2);
        JDialog jDialog = jOptionPane.createDialog(GUI.getFrame(), "Choose Parameters for Counterexample");
        jDialog.setVisible(true);
        if (jOptionPane.getValue() == null || !jOptionPane.getValue().equals(0)) {
            return false;
        }
        counterExampleSearchParameters.setAbstractSearch(this.abstractButton.isSelected());
        counterExampleSearchParameters.setGlobalSearch(this.globalButton.isSelected());
        counterExampleSearchParameters.setClosure(this.closureButton.isSelected());
        return true;
    }
}

