/*
 * Decompiled with CFR 0.152.
 */
package comics.io;

import comics.SCC_MC;
import comics.data.Config;
import comics.gui.GUI;
import comics.io.ExtensionFileFilter;
import comics.io.ExtensionType;
import comics.utilities.Output;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.JFileChooser;

public class FileHandler {
    public FileHandler() {
        this.loadDefaultFilePath();
    }

    public File getOpenFile(ExtensionType[] extensionTypeArray) {
        String string = "";
        for (int i = 0; i < extensionTypeArray.length - 1; ++i) {
            string = string + (Object)((Object)extensionTypeArray[i]) + ", ";
        }
        string = string + (Object)((Object)extensionTypeArray[extensionTypeArray.length - 1]);
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(string, extensionTypeArray);
        return this.showFileDialog(extensionFileFilter, true);
    }

    public File getOpenFile(ExtensionType extensionType) {
        return this.getOpenFile(new ExtensionType[]{extensionType});
    }

    public File getSaveFile(ExtensionType[] extensionTypeArray, String string) {
        String string2 = "";
        for (int i = 0; i < extensionTypeArray.length - 1; ++i) {
            string2 = string2 + (Object)((Object)extensionTypeArray[i]) + ", ";
        }
        string2 = string2 + (Object)((Object)extensionTypeArray[extensionTypeArray.length - 1]);
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(string2, extensionTypeArray);
        return this.showFileDialog(extensionFileFilter, false);
    }

    public File getSaveFile(ExtensionType extensionType, String string) {
        return this.getSaveFile(new ExtensionType[]{extensionType}, string);
    }

    private File showFileDialog(ExtensionFileFilter extensionFileFilter, boolean bl) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(extensionFileFilter);
        jFileChooser.setCurrentDirectory(Config.path);
        int n = 0;
        n = bl ? jFileChooser.showOpenDialog(GUI.getFrame()) : jFileChooser.showSaveDialog(GUI.getFrame());
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                Output.print("Couldn't open file");
                return null;
            }
            if (!extensionFileFilter.accept(file)) {
                file = new File(file.getAbsolutePath() + "." + extensionFileFilter.getFirstExtension());
            }
            SCC_MC.getInstance().getGui().setStatusBarMessage(file.getName());
            this.saveDefaultFilePath(file.getParentFile());
            return file;
        }
        Output.print("1");
        return null;
    }

    public static String fileContentToString(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            FileReader fileReader = new FileReader(file);
            while ((n = fileReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean StringToFileContent(String string, File file) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file));
            try {
                outputStreamWriter.write(string);
            }
            finally {
                outputStreamWriter.close();
            }
        }
        catch (Exception exception) {
            Output.print("Couldn't write string to file");
            return false;
        }
        return true;
    }

    private void loadDefaultFilePath() {
        File file = new File("path.txt");
        if (file.exists()) {
            try {
                String string = FileHandler.fileContentToString(new File("path.txt"));
                Config.path = new File(string);
            }
            catch (Exception exception) {
                Output.print("path.txt doesn't exist");
            }
        } else {
            Config.path = new File(".");
        }
        Output.print(Config.path.toString());
    }

    private void saveDefaultFilePath(File file) {
        Config.path = file;
        File file2 = new File("path.txt");
        try {
            FileWriter fileWriter = new FileWriter(file2, false);
            fileWriter.write(file.getPath());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

