/*
 * Decompiled with CFR 0.152.
 */
package comics.io.input;

import comics.data.Config;
import comics.data.CounterExampleSearchParameters;
import comics.io.FileHandler;
import comics.io.input.InputParser;
import comics.utilities.Output;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfReader
extends InputParser {
    public int count = 0;
    String fileContent = null;
    CounterExampleSearchParameters parameters;

    public ConfReader(File file, CounterExampleSearchParameters counterExampleSearchParameters) {
        super(file);
        this.parameters = counterExampleSearchParameters;
    }

    @Override
    public boolean parse() {
        if (this.fileToReadFrom != null) {
            this.fileContent = FileHandler.fileContentToString(this.fileToReadFrom);
        }
        if (this.fileContent != null) {
            try {
                String[] stringArray;
                for (String string : stringArray = this.fileContent.split("\\r?" + Output.getLineBreak())) {
                    Pattern pattern = Pattern.compile("((?i)TASK) ((?i)modelchecking)");
                    Matcher matcher = pattern.matcher(string);
                    Pattern pattern2 = Pattern.compile("((?i)TASK) ((?i)counterexample)");
                    Matcher matcher2 = pattern2.matcher(string);
                    Pattern pattern3 = Pattern.compile("((?i)PROBABILITY_BOUND) ((\\b(\\d+)\\.(\\d+)\\b))");
                    Matcher matcher3 = pattern3.matcher(string);
                    Pattern pattern4 = Pattern.compile("((?i)REPRESENTATION) ((?i)subsystem)");
                    Matcher matcher4 = pattern4.matcher(string);
                    Pattern pattern5 = Pattern.compile("((?i)REPRESENTATION) ((?i)pathset)");
                    Matcher matcher5 = pattern5.matcher(string);
                    Pattern pattern6 = Pattern.compile("((?i)SEARCH_ALGORITHM) ((?i)local)");
                    Matcher matcher6 = pattern6.matcher(string);
                    Pattern pattern7 = Pattern.compile("((?i)SEARCH_ALGORITHM) ((?i)global)");
                    Matcher matcher7 = pattern7.matcher(string);
                    Pattern pattern8 = Pattern.compile("((?i)ABSTRACTION) ((?i)abstract)");
                    Matcher matcher8 = pattern8.matcher(string);
                    Pattern pattern9 = Pattern.compile("((?i)ABSTRACTION) ((?i)concrete)");
                    Matcher matcher9 = pattern9.matcher(string);
                    Pattern pattern10 = Pattern.compile("((?i)[DTMC|XML]_FILE) ((?i).*\\.(dtmc|xml|tra))");
                    Matcher matcher10 = pattern10.matcher(string);
                    Pattern pattern11 = Pattern.compile("((?i)DTMC_FILE) ((?i).*\\.conf)");
                    Matcher matcher11 = pattern11.matcher(string);
                    if (matcher.find()) {
                        Output.print("TASK: Model Checking");
                        Config.task = "modelchecking";
                        continue;
                    }
                    if (matcher2.find()) {
                        Output.print("TASK: Counterexample Generation");
                        Config.task = "counterexample";
                        continue;
                    }
                    if (matcher3.find()) {
                        this.parameters.setProbabilityBound(Double.valueOf(matcher3.group(3)));
                        Output.print("Probability Bound: " + this.parameters.getProbabilityBound());
                        continue;
                    }
                    if (matcher4.find()) {
                        Output.print("Representation: Critical Subsystem");
                        this.parameters.setClosure(true);
                        continue;
                    }
                    if (matcher5.find()) {
                        Output.print("Representation: Set of Paths");
                        this.parameters.setClosure(false);
                        continue;
                    }
                    if (matcher6.find()) {
                        Output.print("Search Algorithm: Local Search");
                        this.parameters.setGlobalSearch(false);
                        continue;
                    }
                    if (matcher7.find()) {
                        Output.print("Search Algorithm: Global Search");
                        this.parameters.setGlobalSearch(true);
                        continue;
                    }
                    if (matcher8.find()) {
                        Output.print("Abstraction: abstract");
                        this.parameters.setAbstractSearch(true);
                        continue;
                    }
                    if (matcher9.find()) {
                        Output.print("Abstraction: concrete");
                        this.parameters.setAbstractSearch(false);
                        continue;
                    }
                    if (matcher10.find()) {
                        this.handleDTMCFile(matcher10);
                        continue;
                    }
                    if (matcher11.find()) {
                        Output.print(".conf File is no proper dtmc file...");
                        continue;
                    }
                    Output.print("Line: '" + string + "' is not valid.");
                }
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            Output.print("No file and no string");
            return false;
        }
        return true;
    }

    private void handleDTMCFile(Matcher matcher) {
        Config.filename = matcher.group(2);
        this.result = null;
        Output.print("DTMC File: " + Config.filename);
    }
}

