/*
 * Decompiled with CFR 0.152.
 */
package comics.io.input;

import comics.SCC_MC;
import comics.data.ModelCheckResult;
import comics.graph.data.MarkovChain;
import comics.graph.data.Node;
import comics.graph.data.ProbabilityExceededException;
import comics.io.input.InputParser;
import comics.utilities.Output;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser
extends InputParser {
    private String xmldoc;

    public XmlParser(String string) {
        super(null);
        this.xmldoc = string;
    }

    @Override
    public boolean parse() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.xmldoc.getBytes());
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            DTMCHandler dTMCHandler = new DTMCHandler();
            sAXParser.parse((InputStream)byteArrayInputStream, (DefaultHandler)dTMCHandler);
            this.result = dTMCHandler.getResult();
            return this.result != null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return false;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private class DTMCHandler
    extends DefaultHandler {
        MarkovChain mc = null;
        MarkovChain toplevelMC = null;
        char nextNodeType;
        boolean isToplevel = true;
        double xpos;
        double ypos;

        private DTMCHandler() {
        }

        public MarkovChain getResult() {
            return this.mc;
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
            Node node = this.toplevelMC.getInputNodes().first();
            if (this.toplevelMC.getSubgraphs().size() == 0) {
                this.toplevelMC.setReduced(false);
                this.toplevelMC.setInputOfSccNode(node, false);
                this.toplevelMC.setInitialNode(node);
            } else {
                this.toplevelMC.setInitialNode(node);
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.xpos = -1.0;
            this.ypos = -1.0;
            if (string3.equals("vtx")) {
                this.nextNodeType = (char)118;
                this.setPosition(attributes);
            } else if (string3.equals("inp")) {
                this.nextNodeType = (char)105;
                this.setPosition(attributes);
            } else if (string3.equals("out")) {
                this.nextNodeType = (char)111;
                this.setPosition(attributes);
            } else if (string3.equals("target")) {
                this.nextNodeType = (char)116;
            } else if (string3.equals("prob")) {
                this.nextNodeType = (char)112;
            } else if (string3.equals("edg")) {
                this.nextNodeType = (char)45;
                boolean bl = false;
                int n = -1;
                int n2 = -1;
                double d = -1.0;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("abs")) {
                        bl = attributes.getValue(i).equals("1");
                        continue;
                    }
                    if (attributes.getQName(i).equals("src")) {
                        n = Integer.parseInt(attributes.getValue(i));
                        continue;
                    }
                    if (attributes.getQName(i).equals("trg")) {
                        n2 = Integer.parseInt(attributes.getValue(i));
                        continue;
                    }
                    if (!attributes.getQName(i).equals("prb")) continue;
                    d = Double.parseDouble(attributes.getValue(i));
                }
                try {
                    this.mc.addEdge(this.toplevelMC.getNodeByIntName(n), this.toplevelMC.getNodeByIntName(n2), d, bl);
                }
                catch (ProbabilityExceededException probabilityExceededException) {
                    Output.print(probabilityExceededException.toString());
                }
            } else if (string3.equals("scc")) {
                this.nextNodeType = (char)45;
                if (this.mc == null) {
                    this.toplevelMC = this.mc = new MarkovChain();
                } else {
                    MarkovChain markovChain = new MarkovChain();
                    if (attributes.getLength() > 0) {
                        markovChain.setId(Integer.parseInt(attributes.getValue(0)));
                    }
                    this.mc.addSubgraph(markovChain);
                    markovChain.setParent(this.mc);
                    this.mc = markovChain;
                    this.isToplevel = false;
                }
                this.mc.setReduced(true);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals("id")) continue;
                    this.mc.setId(Integer.parseInt(attributes.getValue(i)));
                }
            } else {
                this.nextNodeType = (char)45;
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (string3.equals("scc") && this.mc.getParent() != null) {
                this.mc = this.mc.getParent();
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            int n3;
            if (this.nextNodeType == 'p') {
                String string = "";
                for (int i = n; i < n + n2; ++i) {
                    string = string + cArray[i];
                }
                double d = Double.parseDouble(string);
                ModelCheckResult modelCheckResult = new ModelCheckResult(XmlParser.this.xmldoc, d);
                SCC_MC.getInstance().setModelCheckResult(modelCheckResult);
                this.nextNodeType = (char)45;
                return;
            }
            if (this.nextNodeType == '-') {
                return;
            }
            String string = "";
            for (n3 = n; n3 < n + n2; ++n3) {
                string = string + cArray[n3];
            }
            n3 = Integer.parseInt(string);
            Node node = null;
            if (this.isToplevel && this.nextNodeType != 't' && !this.mc.containsNode(n3)) {
                node = this.mc.addNode(n3);
                if (this.xpos >= 0.0 && this.ypos >= 0.0) {
                    node.setPosition(this.xpos, this.ypos);
                }
            } else {
                node = this.toplevelMC.getNodeByIntName(n3);
                if (node == null) {
                    Output.print("Should not be reached");
                }
            }
            if (this.nextNodeType == 'i') {
                this.mc.setInputOfSccNode(node);
                this.mc.setCorrespondingMarkovChainNode(node);
            } else if (this.nextNodeType == 'o') {
                this.mc.setOutputOfSccNode(node);
            } else if (this.nextNodeType == 'v') {
                if (!node.isInputOfScc()) {
                    this.mc.setNormalNode(node);
                }
            } else if (this.nextNodeType == 't') {
                this.mc.setTargetNode(node);
            }
            this.nextNodeType = (char)45;
        }

        private void setPosition(Attributes attributes) {
            if (this.isToplevel) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("xpos")) {
                        this.xpos = Double.parseDouble(attributes.getValue(i));
                        continue;
                    }
                    if (!attributes.getQName(i).equals("ypos")) continue;
                    this.ypos = Double.parseDouble(attributes.getValue(i));
                }
            }
        }
    }
}

