/*
 * Decompiled with CFR 0.152.
 */
package comics.tools;

import comics.graph.data.MarkovChain;
import comics.graph.data.Node;
import comics.graph.data.ProbabilityExceededException;
import comics.utilities.Either;
import comics.utilities.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import prismparser.casestudies.CaseStudyGenerator;
import prismparser.casestudies.CrowdsGenerator;
import prismparser.casestudies.SyncLeaderGenerator;
import prismparser.external.Edge;
import prismparser.external.ParserCall;
import prismparser.external.Vertex;

public class PrismParser {
    public Either<ArrayList<String>, MarkovChain> parseModel(CaseStudyGenerator caseStudyGenerator) {
        ParserCall parserCall = new ParserCall(caseStudyGenerator);
        return this.coordinateParsing(parserCall);
    }

    public Either<ArrayList<String>, MarkovChain> getCrowdsModel(int n, int n2) {
        return this.parseModel((CaseStudyGenerator)new CrowdsGenerator(n, n2));
    }

    public Either<ArrayList<String>, MarkovChain> getLeaderModel(int n, int n2) {
        return this.parseModel((CaseStudyGenerator)new SyncLeaderGenerator(n, n2));
    }

    public Either<ArrayList<String>, MarkovChain> parseModel(String string) {
        return this.parseModel(string, "");
    }

    public Either<ArrayList<String>, MarkovChain> parseModel(String string, String string2) {
        ParserCall parserCall = new ParserCall(string, string2);
        return this.coordinateParsing(parserCall);
    }

    private Either<ArrayList<String>, MarkovChain> coordinateParsing(ParserCall parserCall) {
        prismparser.external.MarkovChain markovChain = parserCall.runParser();
        if (markovChain == null) {
            return new Either<ArrayList, Object>(parserCall.errors(), null);
        }
        Output.print("The following Markov Chain was generated:");
        Output.print(markovChain.toString());
        MarkovChain markovChain2 = this.transformMarkovChain(markovChain);
        return new Either<Object, MarkovChain>(null, markovChain2);
    }

    private MarkovChain transformMarkovChain(prismparser.external.MarkovChain markovChain) {
        Iterator iterator;
        Node node;
        MarkovChain markovChain2 = new MarkovChain();
        ArrayList arrayList = markovChain.vertices();
        HashSet hashSet = markovChain.initStates();
        HashSet hashSet2 = markovChain.targetStates();
        HashMap<Integer, Node> hashMap = new HashMap<Integer, Node>();
        for (Vertex vertex : arrayList) {
            node = markovChain2.addNode(vertex.getId());
            hashMap.put(vertex.getId(), node);
        }
        if (hashSet != null) {
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                node = (Node)hashMap.get(n);
                markovChain2.setInitialNode(node);
            }
        }
        if (hashSet2 != null) {
            iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                node = (Node)hashMap.get(n);
                markovChain2.setTargetNode(node);
            }
        }
        for (Vertex vertex : arrayList) {
            node = (Node)hashMap.get(vertex.getId());
            for (Edge edge : vertex.getEdges()) {
                Node node2 = (Node)hashMap.get(edge.getTarget());
                try {
                    markovChain2.addEdge(node, node2, edge.getProbability());
                }
                catch (ProbabilityExceededException probabilityExceededException) {
                    Output.print(probabilityExceededException.toString());
                }
            }
        }
        return markovChain2;
    }
}

