/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
*/

#ifndef CLOSURE_H_
#define CLOSURE_H_

#include "../defines.h"
#include "../GraphTypes.h"
#include "extrack/AbstractExtensionTracker.h"

namespace scc_cex {

extern bool resetClosure;

/*
 * Realized closure computation by model checking,
 * i.e. copying the visible part of the graph and have it model checked.
 * This copying is done incrementally, i.e. if nodes and edges have already
 * been added to the closure in a previous step, there will not be additional
 * copying operations for these objects.
 * (This is achieved in a rather dirty way I'm afraid...)
 */
class Closure {
public:
	Closure(Vertex<PTYPE>* source, Vertex<PTYPE>* target, AbstractExtensionTracker* tracker);
	virtual ~Closure();

	PTYPE getProbMass();
private:
	Graph<PTYPE>* mGraph;
	Vertex<PTYPE>* mSource;
	Vertex<PTYPE>* mTarget;
	AbstractExtensionTracker* mTracker;

	PTYPE mProbMass;

	Graph<PTYPE>* closureGraph;

	void computeByModelChecking();
	void copyVisibleGraph(std::vector<Vertex<PTYPE>*>& vertexList, int& initialNode, int& targetNode);
	void refineClosure();

	Vertex<PTYPE>* copyVertex(Vertex<PTYPE>* vtx) const;
	Edge<PTYPE>* copyEdge(Edge<PTYPE>* edge) const;
};

}

#endif /* CLOSURE_H_ */
