/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
*/

/*
 * CounterExampleParams.h
 *
 *  Created on: 22.03.2011
 *      Author: jens
 */

#ifndef COUNTEREXAMPLEPARAMS_H_
#define COUNTEREXAMPLEPARAMS_H_

#include <string>
#include <iostream>

namespace scc_cex {

typedef enum StateSelectionMode {
	SELECT_HIGHEST,
	SELECT_DEEPEST,
	SELECT_ALL,
	SELECT_USER_INPUT
} StateSelectionMode;

extern std::string selectionModeToString(const StateSelectionMode m);

//Correspond to java, don't change values
typedef enum FilterMode {
	FILTER_NONE = 0,
	FILTER_SCC_SIZE = 1,
	FILTER_ABSTRACT_EDGE_PROBABILITY = 2,
	FILTER_INPUT_OUTPUT_DEGREE = 3,
	FILTER_RELATIVE_USAGE = 4
} FilterMode;

extern std::string filterModeToString(const FilterMode m);

//Correspond to java, don't change values
typedef enum ConcretizationMode {
	CONCRETIZE_SQRT = 0,
	CONCRETIZE_ONE = 1,
	CONCRETIZE_ALL = 2,
} ConcretizationMode;

extern std::string concModeToString(const ConcretizationMode m);

class CounterExampleParams {
public:
	CounterExampleParams(const bool doGlobalSearch, const bool doAbstractSearch, const ConcretizationMode concMode,
			const StateSelectionMode selectionMode, const FilterMode filterMode);

	bool mUseGlobalSearch;
	bool mUseAbstractSearch;
	ConcretizationMode mConcMode;
	StateSelectionMode mSelectionMode;
	FilterMode mFilterMode;

	std::string getParamHash();

	friend std::ostream& operator<<(std::ostream& os, const CounterExampleParams& rhs);
};

}

#endif /* COUNTEREXAMPLEPARAMS_H_ */
