/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
*/

/*
 * CriticalSubSystem.h
 *
 *  Created on: 03.06.2011
 *      Author: jens
 */

#ifndef CRITICALSUBSYSTEM_H_
#define CRITICALSUBSYSTEM_H_

#include "../defines.h"
#include "../GraphTypes.h"
#include "extrack/AbstractExtensionTracker.h"

namespace scc_cex {

/**
 * Represents a critical subsystem, i.e. it holds the administrative info
 * necessary to have closures generated and has methods to do precisely that.
 */
class CriticalSubSystem {
public:
	CriticalSubSystem(Vertex<PTYPE>* cexInputNode, Vertex<PTYPE>* cexTargetNode);
	virtual ~CriticalSubSystem();

	void setPointerBasedEdgeTracking(const bool enable);

	bool addPathToSubSystem(Path* pi);
	void removeUnusedEdges();
	PTYPE generateClosure();

	void addEdgeToTrack(Edge<PTYPE>* e);

	AbstractExtensionTracker* getTracker();
private:
    AbstractExtensionTracker* mTracker;

    Vertex<PTYPE>* mCexInputNode;
    Vertex<PTYPE>* mCexTargetNode;
};

}

#endif /* CRITICALSUBSYSTEM_H_ */
