/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
*/

/*
 * Statistics.h
 *
 *  Created on: 17.03.2011
 *      Author: jens
 */

#ifndef STATISTICS_H_
#define STATISTICS_H_

#include <vector>
#include <stdlib.h>

#include "../defines.h"
#include "../typedefs.h"
#include "AbstractStateSelector.h"

namespace scc_cex {

class Statistics {
public:
	static Statistics *getInstance();

	std::string generateSummary() const;

	void addStep(const unsigned int nrOfPaths, const unsigned int nrOfClosures, const unsigned int concretizedScc);
	void startTime();
	void stopTime();
	void startModelCheckerTime();
	void stopModelCheckerTime();
	void setSearchParams(const bool doGlobal, const bool doAbstract, const bool doClosures);
	void setConcretizationParams(const ConcretizationMode concMode, const StateSelectionMode selectionMode, const FilterMode filterMode);
	void setCounterExampleTask(const OperatorType op, const PTYPE probBound);
	void setCounterExampleSize(const unsigned int nrOfNodes, const unsigned int nrOfEdges);
	void setProb(PTYPE prob);
	PTYPE getProb();
	void setMcResult(PTYPE prob);

	unsigned int getNumberOfSteps() const;
	unsigned int getPathCountByStep(const unsigned int step) const;
	unsigned int getClosureCountByStep(const unsigned int step) const;
	unsigned int getConcretizedSccCountByStep(const unsigned int step) const;

private:
	Statistics();
	virtual ~Statistics();

	Statistics(const Statistics&) {}
	Statistics& operator=(const Statistics&) {}


	std::vector<unsigned int> mPathCountByStep;
	std::vector<unsigned int> mClosureCountByStep;
	std::vector<unsigned int> mConcretizedSccByStep;

	unsigned int mNrOfNodes, mNrOfEdges;

	bool mSearchParamsSet, mDoGlobal, mDoAbstract, mDoClosures;

	bool mConcretizationSet;
	ConcretizationMode mConcMode;
	StateSelectionMode mSelectionMode;
	FilterMode mFilterMode;

	bool mTaskSet;
	OperatorType mOp;
	PTYPE mProbBound;

	PTYPE mClosProb;

	PTYPE mMcResult;

	clock_t t_modelCheckerStart;
	clock_t t_modelCheckerEnd;

	clock_t t_start;
	clock_t t_end;
};

}

#endif /* STATISTICS_H_ */
