/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
*/

/*
 * AbstractExtensionTracker.cpp
 *
 *  Created on: 03.06.2011
 *      Author: jens
 */

#include "AbstractExtensionTracker.h"

namespace scc_cex {

AbstractExtensionTracker::AbstractExtensionTracker() {
	// Nothing to do here right now

}

AbstractExtensionTracker::~AbstractExtensionTracker() {
	// Nothing to do here right now
}

std::set<Edge<PTYPE>*>& AbstractExtensionTracker::getExtension() {
	return mExtension;
}

bool AbstractExtensionTracker::isClosureExtensionPending() {
	//TODO: Might refine this, e.g. by saying that depending on the current number of paths, not every single extension triggers closure computation. If you change this, make sure that you don't break the Heuristic Assignment Sbmc implementation
	return !mExtension.empty();
}

/*
 * Signal to the extension tracker that the last extension was carried out
 * This resets the Tracker
 */
void AbstractExtensionTracker::signalClosureExtensionFinished() {
	mExtension.clear();
}

}
