/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
*/

/*
 * AbstractExtensionTracker.h
 *
 *  Created on: 03.06.2011
 *      Author: jens
 */

#ifndef ABSTRACTEXTENSIONTRACKER_H_
#define ABSTRACTEXTENSIONTRACKER_H_

#include <set>
#include "../../GraphTypes.h"

namespace scc_cex {

/**
 * This is the abstract super class of the extension trackers.
 * An extension tracker is an object that keeps track of the known edges as paths
 * are added to the closure.
 * A call to isClosureExtensionPending() returns whether any new edges have been
 * added since the last closure computation.
 * We need different concrete implementations for external and internal callers,
 * see the subclasses.
 */
class AbstractExtensionTracker {
public:
	AbstractExtensionTracker();
	virtual ~AbstractExtensionTracker();

	edge_set& getExtension();
	bool isClosureExtensionPending();
	void signalClosureExtensionFinished();

	virtual void processPath(Path* pi) = 0;
	/** Only for abstract search: mark the edges as closure-extension-relevant */
	virtual void addEdgeToTrack(Edge<PTYPE>* e) = 0;

	virtual void signalResetTracking() = 0;

	virtual unsigned int numberOfEdgeCandidates() = 0;

protected:
	edge_set mExtension;
};

}

#endif /* ABSTRACTEXTENSIONTRACKER_H_ */
