/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
*/

/*
 * ContentExtensionTracker.cpp
 *
 *  Created on: 03.06.2011
 *      Author: jens
 */

#include <sstream>
#include "ContentExtensionTracker.h"

using namespace std;

namespace scc_cex {

ContentExtensionTracker::ContentExtensionTracker() {
}

ContentExtensionTracker::~ContentExtensionTracker() {
}

void ContentExtensionTracker::processPath(Path* pi) {
	Path* curr = pi;
	while (curr != NULL) {
		Edge<PTYPE>* e = curr->edge;
		if (e != NULL) {
			string hash = edgeHash(e);

			if (mKnownEdges.find(hash) == mKnownEdges.end()) {
				//Edge now necessary for closure -> add to m_min
				e->not_m_min = false;
				mKnownEdges.insert(hash);
				mExtension.insert(e);
			}
		}

		curr = curr->pred;
	}
}

void ContentExtensionTracker::addEdgeToTrack(Edge<PTYPE>* e) {
	//Not necessary as this is only for concrete searches!
}

void ContentExtensionTracker::signalResetTracking() {
	mKnownEdges.clear();

	//Should usually be redundant
	mExtension.clear();
}

unsigned int ContentExtensionTracker::numberOfEdgeCandidates() {
	return mKnownEdges.size();
}

std::string ContentExtensionTracker::edgeHash(const Edge<PTYPE>* e) const {
	stringstream ss;
	ss << e->source->oindex << "_" << e->target->oindex;
	return ss.str();
}

}
