/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
*/

/*
 * ExtensionTracker.cpp
 *
 *  Created on: 16.03.2011
 *      Author: jens
 */

#include "PointerExtensionTracker.h"

using namespace std;

namespace scc_cex {

PointerExtensionTracker::PointerExtensionTracker() {
	// Nothing to do here right now

}

PointerExtensionTracker::~PointerExtensionTracker() {
	// Nothing to do here right now
}

void PointerExtensionTracker::processPath(Path* pi) {
	Path* curr = pi;
	while (curr != NULL) {
		Edge<PTYPE>* e = curr->edge;
		if (e != NULL) {
			if (e->not_m_min) {
				//Edge now necessary for closure -> add to m_min
				e->not_m_min = false;
				mEdgesToTrack.erase(e);
				mExtension.insert(e);
			}
		}

		curr = curr->pred;
	}
}

void PointerExtensionTracker::addEdgeToTrack(Edge<PTYPE>* e) {
	e->setMark(true); //If it is to be tracked, it is to be found, so it should be visible

	e->not_m_min = true; //New edge in m_max \ m_min
	mEdgesToTrack.insert(e);
}

void PointerExtensionTracker::signalResetTracking() {
	for (set<Edge<PTYPE>*>::iterator it = mEdgesToTrack.begin(); it != mEdgesToTrack.end(); it++) {
		//It is enough to unmark the edge, as it won't be found any more we don't need
		//to reset the not_m_min flag
		(*it)->setMark(false);
	}
	mEdgesToTrack.clear();

	//Should usually be redundant
	mExtension.clear();
}

unsigned int PointerExtensionTracker::numberOfEdgeCandidates() {
	return mEdgesToTrack.size();
}

}
