/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
*/

/*
 * ExtensionTracker.h
 *
 *  Created on: 16.03.2011
 *      Author: jens
 */

#ifndef EXTENSIONTRACKER_H_
#define EXTENSIONTRACKER_H_

#include <set>
#include "../../GraphTypes.h"
#include "AbstractExtensionTracker.h"

namespace scc_cex {

/*
 * This extension tracker keeps track of the edges by looking at the
 * pointers of the edges. This is both time and space efficient, but
 * presupposes that pointers to edges remain consistent over time,
 * i.e. using it results in relatively strong restrictions on the calling
 * objects.
 * It is safe to use this class with the current shortest path and
 * counter example implementations.
 */
class PointerExtensionTracker : public AbstractExtensionTracker {
public:
	PointerExtensionTracker();
	virtual ~PointerExtensionTracker();

	virtual void processPath(Path* pi);
	virtual void addEdgeToTrack(Edge<PTYPE>* e);

	virtual void signalResetTracking();

	virtual unsigned int numberOfEdgeCandidates();

protected:
	edge_set mEdgesToTrack;
};

}

#endif /* EXTENSIONTRACKER_H_ */
