/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
*/

/*
 * GlobalPathFinder.cpp
 *
 *  Created on: 18.10.2011
 *      Author: jens
 */

#ifdef USE_LOGLIB
#include <log4cplus/logger.h>
#endif
#include "GlobalPathFinder.h"

using namespace std;
using namespace log4cplus;

namespace scc_cex {

GlobalPathFinder::GlobalPathFinder(CexGenerator* cexGen) : PathFinder(cexGen) {

}

GlobalPathFinder::~GlobalPathFinder() {
	// Nothing to do here right now
}

/**
 * In the global search we do not copy any paths but rather return the objects created by the SP algorithm directly.
 * They therefore need not and must not be deleted after they have been used (for closure generation, that is)
 */
bool GlobalPathFinder::pathDeletionNecessary() {
	return false;
}

Path* GlobalPathFinder::nextShortestPath(const unsigned int k) {
	if (k >= 2) nextPath(mCexGen->mCexTargetNode, k);
	else if (k == 1) {
		//Compute the very shortest path to every node; for k>=2 the nextPath algorithm will kick in
		LOG4CPLUS_DEBUG(pathlogger, "Will now start Dijkstra...");
		modifiedDijkstra();
		LOG4CPLUS_DEBUG(pathlogger, "Finished Dijkstra");
	}
	else {
		LOG4CPLUS_ERROR(pathlogger, k << "th shortest path?! Seriously?!");
		assert(false);
		return NULL;
	}

	return mCexGen->mCexTargetNode->getkthShortestPath(k);
}

}
