/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
*/

/*
 * PathFinder.h
 *
 *  Created on: 18.10.2011
 *      Author: jens
 */

#ifndef PATHFINDER_H_
#define PATHFINDER_H_

#include "../../GraphTypes.h"
#include "../gens/CexGenerator.h"

namespace scc_cex {

extern log4cplus::Logger pathlogger;

/**
 * The abstract base class of the path finding algorithms.
 * The pathDeletionNecessary() method is for the relatively lowlevel stuff
 * regarding memory management, see the concrete implementations for details.
 */
class PathFinder {
public:
	PathFinder(CexGenerator* cexGen);
	virtual ~PathFinder();

	virtual Path* nextShortestPath(const unsigned int k) = 0;
	virtual bool pathDeletionNecessary() = 0;
protected:
	void modifiedDijkstra();
	void nextPath(Vertex<PTYPE>* targetNode, const unsigned int k);

	CexGenerator* mCexGen;
};

}

#endif /* PATHFINDER_H_ */
