/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
*/

/*
 * Configuration.cpp
 *
 *  Created on: 09.03.2011
 *      Author: jens
 */

#include <limits.h>
#include "Configuration.h"

namespace scc_cex {


    bool ConfigurationSingleton::isIoflBenchmarkConc() const
    {
        return iofl_benchmark_conc;
    }

    bool ConfigurationSingleton::isIoflBenchmarkHeuristic() const
    {
        return iofl_benchmark_heuristic;
    }

    bool ConfigurationSingleton::isIoflBenchmarkSelection() const
    {
        return iofl_benchmark_selection;
    }

    bool ConfigurationSingleton::isIoflBenchmarkSearch() const
    {
        return iofl_benchmark_search;
    }

    bool ConfigurationSingleton::isIoflBoundPathsum() const
    {
        return iofl_bound_pathsum;
    }

    bool ConfigurationSingleton::isIoflCexConcrete() const
    {
        return iofl_cex_concrete;
    }

    bool ConfigurationSingleton::isIoflCexLocal() const
    {
        return iofl_cex_local;
    }

    bool ConfigurationSingleton::isIoflChooseDegree() const
    {
        return iofl_choose_degree;
    }

    bool ConfigurationSingleton::isIoflChooseMembership() const
    {
        return iofl_choose_membership;
    }

    bool ConfigurationSingleton::isIoflChooseProbability() const
    {
        return iofl_choose_probability;
    }

    bool ConfigurationSingleton::isIoflDtmcOnly() const
    {
        return iofl_dtmc_only;
    }

    bool ConfigurationSingleton::isIoflExternalCaller() const
    {
        return iofl_external_caller;
    }

    bool ConfigurationSingleton::isIoflForceAbstract() const
    {
        return iofl_force_abstract;
    }

    bool ConfigurationSingleton::isIoflForceClosure() const
    {
        return iofl_force_closure;
    }

    bool ConfigurationSingleton::isIoflForceGlobal() const
    {
        return iofl_force_global;
    }

    bool ConfigurationSingleton::isIoflInputIsFile() const
    {
        return iofl_input_is_file;
    }

    bool ConfigurationSingleton::isIoflIoflSaveIterations() const
    {
        return iofl_iofl_save_iterations;
    }

    bool ConfigurationSingleton::isIoflOutputAsDtmc() const
    {
        return iofl_output_as_dtmc;
    }

    bool ConfigurationSingleton::isIoflOutputAsXml() const
    {
        return iofl_output_as_xml;
    }

    bool ConfigurationSingleton::isIoflReadFromXml() const
    {
        return iofl_read_from_xml;
    }

    bool ConfigurationSingleton::isIoflWaitForCalls() const
    {
        return iofl_wait_for_calls;
    }

    void ConfigurationSingleton::setIoflBenchmarkConc(bool ioflBenchmarkConc)
    {
        iofl_benchmark_conc = ioflBenchmarkConc;
    }

    void ConfigurationSingleton::setIoflBenchmarkHeuristic(bool ioflBenchmarkHeuristic)
    {
        iofl_benchmark_heuristic = ioflBenchmarkHeuristic;
    }

    void ConfigurationSingleton::setIoflBenchmarkSelection(bool ioflBenchmarkSelection)
    {
        iofl_benchmark_selection = ioflBenchmarkSelection;
    }

    void ConfigurationSingleton::setIoflBenchmarkSearch(bool ioflBenchmarkSearch)
    {
        iofl_benchmark_search = ioflBenchmarkSearch;
    }

    void ConfigurationSingleton::setIoflBoundPathsum(bool ioflBoundPathsum)
    {
        iofl_bound_pathsum = ioflBoundPathsum;
    }

    void ConfigurationSingleton::setIoflCexConcrete(bool ioflCexConcrete)
    {
        iofl_cex_concrete = ioflCexConcrete;
    }

    void ConfigurationSingleton::setIoflCexLocal(bool ioflCexLocal)
    {
        iofl_cex_local = ioflCexLocal;
    }

    void ConfigurationSingleton::setIoflChooseDegree(bool ioflChooseDegree)
    {
        iofl_choose_degree = ioflChooseDegree;
    }

    void ConfigurationSingleton::setIoflChooseMembership(bool ioflChooseMembership)
    {
        iofl_choose_membership = ioflChooseMembership;
    }

    void ConfigurationSingleton::setIoflChooseProbability(bool ioflChooseProbability)
    {
        iofl_choose_probability = ioflChooseProbability;
    }

    void ConfigurationSingleton::setIoflDtmcOnly(bool ioflDtmcOnly)
    {
        iofl_dtmc_only = ioflDtmcOnly;
    }

    void ConfigurationSingleton::setIoflExternalCaller(bool ioflExternalCaller)
    {
        iofl_external_caller = ioflExternalCaller;
    }

    void ConfigurationSingleton::setIoflForceAbstract(bool ioflForceAbstract)
    {
        iofl_force_abstract = ioflForceAbstract;
    }

    void ConfigurationSingleton::setIoflForceClosure(bool ioflForceClosure)
    {
        iofl_force_closure = ioflForceClosure;
    }

    void ConfigurationSingleton::setIoflForceGlobal(bool ioflForceGlobal)
    {
        iofl_force_global = ioflForceGlobal;
    }

    void ConfigurationSingleton::setIoflInputIsFile(bool ioflInputIsFile)
    {
        iofl_input_is_file = ioflInputIsFile;
    }

    void ConfigurationSingleton::setIoflIoflSaveIterations(bool ioflIoflSaveIterations)
    {
        iofl_iofl_save_iterations = ioflIoflSaveIterations;
    }

    void ConfigurationSingleton::setIoflOutputAsDtmc(bool ioflOutputAsDtmc)
    {
        iofl_output_as_dtmc = ioflOutputAsDtmc;
    }

    void ConfigurationSingleton::setIoflOutputAsXml(bool ioflOutputAsXml)
    {
        iofl_output_as_xml = ioflOutputAsXml;
    }

    void ConfigurationSingleton::setIoflReadFromXml(bool ioflReadFromXml)
    {
        iofl_read_from_xml = ioflReadFromXml;
    }

    bool ConfigurationSingleton::isIoflInputIsData() const
    {
        return iofl_input_is_data;
    }

    bool ConfigurationSingleton::isIoflForceProbBound() const
    {
        return iofl_force_probBound;
    }

    void ConfigurationSingleton::setIoflForceProbBound(bool ioflForceProbBound)
    {
        iofl_force_probBound = ioflForceProbBound;}

    void ConfigurationSingleton::setIoflInputIsData(bool ioflInputIsData)
    {
        iofl_input_is_data = ioflInputIsData;}

    void ConfigurationSingleton::setIoflWaitForCalls(bool ioflWaitForCalls)
    {
        iofl_wait_for_calls = ioflWaitForCalls;
    }


ConfigurationSingleton* ConfigurationSingleton::getInstance()
{
	  static ConfigurationSingleton instance;
	  return &instance;
}

}
