/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
 */

/*
 * Configuration.h
 *
 *  Created on: 09.03.2011
 *      Author: jens
 */

#ifndef CONFIGURATION_H_
#define CONFIGURATION_H_

#include <vector>
#include <iostream>

namespace scc_cex {

class ConfigurationSingleton {
private:
	ConfigurationSingleton() {}
	ConfigurationSingleton(const ConfigurationSingleton&) {
	}
	ConfigurationSingleton& operator=(const ConfigurationSingleton&) {
	}

	bool iofl_wait_for_calls;
	bool iofl_input_is_file;
	bool iofl_input_is_data;
	bool iofl_external_caller;
	bool iofl_benchmark_search;
	bool iofl_benchmark_heuristic;
	bool iofl_benchmark_conc;
	bool iofl_benchmark_selection;
	bool iofl_bound_pathsum;
	bool iofl_cex_local;
	bool iofl_cex_concrete;
	bool iofl_noModelChecking;
	bool iofl_onlyModelChecking;
	bool iofl_dtmc_only;
	bool iofl_read_from_xml;
	bool iofl_choose_degree;
	bool iofl_choose_membership;
	bool iofl_choose_probability;
	bool iofl_iofl_save_iterations;
	bool iofl_output_as_xml;
	bool iofl_output_as_dtmc;
	bool iofl_force_closure;
	bool iofl_force_abstract;
	bool iofl_force_global;
	bool iofl_force_probBound;

public:
	std::vector<bool> userInputConcretized;
	static ConfigurationSingleton* getInstance();
	bool autoConcretize;

	bool isIoflOnlyModelChecking() const {
		return iofl_onlyModelChecking;
	}

	void setIoflOnlyModelChecking(bool ioflOnlyModelChecking) {
		iofl_onlyModelChecking = ioflOnlyModelChecking;
	}

	bool isIoflNoModelChecking() const
	{
		return iofl_noModelChecking;
	}

	void setIoflNoModelChecking(bool ioflNoModelChecking)
	{
		iofl_noModelChecking = ioflNoModelChecking;
	}

	bool isIoflForceProbBound() const;
	void setIoflForceProbBound(bool ioflForceProbBound);
	bool isIoflBenchmarkConc() const;
	bool isIoflBenchmarkHeuristic() const;
	bool isIoflBenchmarkSelection() const;
	bool isIoflBenchmarkSearch() const;
	bool isIoflBoundPathsum() const;
	bool isIoflCexConcrete() const;
	bool isIoflCexLocal() const;
	bool isIoflChooseDegree() const;
	bool isIoflChooseMembership() const;
	bool isIoflChooseProbability() const;
	bool isIoflDtmcOnly() const;
	bool isIoflExternalCaller() const;
	bool isIoflForceAbstract() const;
	bool isIoflForceClosure() const;
	bool isIoflForceGlobal() const;
	bool isIoflInputIsFile() const;
	bool isIoflIoflSaveIterations() const;
	bool isIoflOutputAsDtmc() const;
	bool isIoflOutputAsXml() const;
	bool isIoflReadFromXml() const;
	bool isIoflWaitForCalls() const;
	void setIoflBenchmarkConc(bool ioflBenchmarkConc);
	void setIoflBenchmarkHeuristic(bool ioflBenchmarkHeuristic);
	void setIoflBenchmarkSelection(bool ioflBenchmarkSelection);
	void setIoflBenchmarkSearch(bool ioflBenchmarkSearch);
	void setIoflBoundPathsum(bool ioflBoundPathsum);
	void setIoflCexConcrete(bool ioflCexConcrete);
	void setIoflCexLocal(bool ioflCexLocal);
	void setIoflChooseDegree(bool ioflChooseDegree);
	void setIoflChooseMembership(bool ioflChooseMembership);
	void setIoflChooseProbability(bool ioflChooseProbability);
	void setIoflDtmcOnly(bool ioflDtmcOnly);
	void setIoflExternalCaller(bool ioflExternalCaller);
	void setIoflForceAbstract(bool ioflForceAbstract);
	void setIoflForceClosure(bool ioflForceClosure);
	void setIoflForceGlobal(bool ioflForceGlobal);
	void setIoflInputIsFile(bool ioflInputIsFile);
	void setIoflIoflSaveIterations(bool ioflIoflSaveIterations);
	void setIoflOutputAsDtmc(bool ioflOutputAsDtmc);
	void setIoflOutputAsXml(bool ioflOutputAsXml);
	void setIoflReadFromXml(bool ioflReadFromXml);
	void setIoflWaitForCalls(bool ioflWaitForCalls);
	bool isIoflInputIsData() const;
	void setIoflInputIsData(bool ioflInputIsData);
};

}

#endif /* CONFIGURATION_H_ */
