/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
 */

package comics.graph.data;

import java.io.Serializable;

import com.mxgraph.model.mxCell;

public class Edge implements Comparable<Edge>, Serializable {

	private static final long serialVersionUID = 1L;
	private Node sourceNode;
	private Node targetNode;
	private double probability;
	private boolean reduced;
	private boolean hidden;

	private mxCell graphCell = null;

	protected Edge(Node sourceNode, Node targetNode, double probability) {
		this(sourceNode, targetNode, probability, false);
	}

	protected Edge(Node sourceNode, Node targetNode, double probability, boolean reduced) {
		this.sourceNode = sourceNode;
		this.targetNode = targetNode;
		setProbability(probability);
		this.reduced = reduced;
	}

	public double getProbability() {
		return probability;
	}

	protected void setProbability(double probability) {
		this.probability = probability;
	}

	public Node getSourceNode() {
		return sourceNode;
	}

	public Node getTargetNode() {
		return targetNode;
	}

	public mxCell getGraphCell() {
		return graphCell;
	}

	public void setGraphCell(mxCell graphCell) {
		this.graphCell = graphCell;
	}

	public boolean isReduced() {
		return reduced;
	}

	public boolean isHidden() {
		return hidden;
	}

	public void setHidden(boolean hidden) {
		this.hidden = hidden;
	}

	@Override
	public int compareTo(Edge o) {
		int i = getSourceNode().compareTo(o.getSourceNode());
		if (i == 0) {
			i = getTargetNode().compareTo(o.getTargetNode());
		}
		return i;
	}

	@Override
	public boolean equals(Object o) {
		if (!(o instanceof Edge))
			return false;
		else {
			Edge e = (Edge) o;
			if (sourceNode.equals(e.sourceNode)) {
				return (targetNode.equals(e.targetNode));
			} else {
				return false;
			}
		}
	}

	public String toTraString() {
		return "" + getSourceNode().getNumber() + " " + getTargetNode().getNumber() + " " + getProbability();

	}

	/**
	 * Generates a custom String for edges with arrow and properties
	 * 
	 * @return string
	 */
	public String toPropertyString() {
		return getSourceNode().getNumber() + " -> " + getTargetNode().getNumber() + ": " + getProbability();
	}

	@Override
	public String toString() {
		return "" + probability;
	}

}
