/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
*/

package comics.graph.gui;

import comics.graph.data.Edge;
import comics.graph.data.Node;

import com.mxgraph.model.mxCell;
import com.mxgraph.view.mxGraph;

public class CustomGraph extends mxGraph {
	
	public CustomGraph() {
		setAllowDanglingEdges(false);
		setAllowLoops(true);
		setAllowNegativeCoordinates(true);
		setCellsEditable(false);
		setSplitEnabled(false);
		setEdgeLabelsMovable(false);
	}

	public String getToolTipForCell(Object cell)
	{
		if (!(cell instanceof mxCell)) return "";
		mxCell mxcell = (mxCell) cell;
		
		String tip = "";

		if (getModel().isEdge(mxcell))
		{
			Edge edge = (Edge) mxcell.getValue();
			tip += edge.toPropertyString();
		}
		else
		{
			Node node = (Node) mxcell.getValue();
			tip = node.propertyString();
		}

		return tip;
	}
}
