package comics.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import comics.SCC_MC;
import comics.graph.data.Edge;
import comics.graph.data.Node;
import comics.graph.gui.GraphWrapper;

public class ContextMenu extends JPopupMenu implements ActionListener {
	private static final long serialVersionUID = 1L;

	private JMenuItem contextMenuSetInitial;
	private JMenuItem contextMenuToggleTarget;
	private JMenuItem contextMenuReduce;
	private JMenuItem contextMenuExpand;
	private JMenuItem contextChangeProbabilitiy;

	private boolean isNode;
	private Node node;
	private Edge edge;

	public ContextMenu() {
		contextMenuSetInitial = new JMenuItem("Choose as initial state");
		contextMenuToggleTarget = new JMenuItem("Toggle target state");
		contextMenuReduce = new JMenuItem("Reduce");
		contextMenuExpand = new JMenuItem("Expand");
		contextChangeProbabilitiy = new JMenuItem("Change probability");

		add(contextMenuSetInitial);
		add(contextMenuToggleTarget);
		add(contextMenuReduce);
		add(contextMenuExpand);
		add(contextChangeProbabilitiy);

		// Action listener support
		contextMenuSetInitial.addActionListener(this);
		contextMenuToggleTarget.addActionListener(this);
		contextMenuReduce.addActionListener(this);
		contextMenuExpand.addActionListener(this);
		contextChangeProbabilitiy.addActionListener(this);
	}

	public void show(MouseEvent evt, Node n) {
		isNode = true;
		node = n;
		show(evt);
	}

	public void show(MouseEvent evt, Edge e) {
		isNode = false;
		edge = e;
		show(evt);
	}

	public void show(MouseEvent e) {
		boolean notIsLocked = !SCC_MC.getInstance().isGraphLocked();
		if (!isNode) {
			contextChangeProbabilitiy.setEnabled(notIsLocked);
			contextMenuSetInitial.setEnabled(false);
			contextMenuToggleTarget.setEnabled(false);
			contextMenuReduce.setEnabled(false);
			contextMenuExpand.setEnabled(false);
		} else {
			contextMenuSetInitial.setEnabled(notIsLocked);
			contextMenuToggleTarget.setEnabled(notIsLocked);
			contextChangeProbabilitiy.setEnabled(false);

			if (node.isInputOfScc()) {
				if (node.isReduced()) {
					contextMenuExpand.setEnabled(true);
					contextMenuReduce.setEnabled(false);
				} else {
					contextMenuExpand.setEnabled(false);
					contextMenuReduce.setEnabled(true);
				}
			} else {
				contextMenuReduce.setEnabled(false);
				contextMenuExpand.setEnabled(false);
			}
		}
		show(e.getComponent(), e.getX(), e.getY());
	}

	public void actionPerformed(ActionEvent e) {
		SCC_MC scc_mc = SCC_MC.getInstance();
		GUI gui = scc_mc.getGui();
		GraphWrapper wrapper = gui.wrapper;
		// Set initial node
		if ("Choose as initial state".equals(e.getActionCommand())) {
			scc_mc.chooseInitialNode(node);
			gui.setStatusBarMessage("Choose as initial state");
		}

		// Set target node
		if ("Toggle target state".equals(e.getActionCommand())) {
			scc_mc.toggleTargetState(node);
			gui.setStatusBarMessage("Chosen as target state");
		}

		// Reduce SCC
		if ("Reduce".equals(e.getActionCommand())) {
			wrapper.reduceSCC(node);
			gui.setStatusBarMessage("Reduced");
		}

		// Expand SCC
		if ("Expand".equals(e.getActionCommand())) {
			wrapper.expandSCC(node);
			gui.setStatusBarMessage("Expanded");
		}

		// Change probability
		if ("Change probability".equals(e.getActionCommand())) {
			wrapper.changeProbability(edge);
		}

		wrapper.requestFocusForGraph();
	}
}
