/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
 */

package comics.gui;

import java.awt.Point;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import comics.io.input.InputParser;

public class ParsingProgress {
	JDialog dialog;
	boolean successful = false;
	InputParser inputParser;

	/**
	 * Constructor
	 * 
	 * @param frame
	 *            Parent frame
	 */
	public ParsingProgress(JFrame frame, InputParser inputParser) {
		this.inputParser = inputParser;
		dialog = new JDialog(frame, "It's gonna be legen... wait for it... ", true);
		JProgressBar progressbar = new JProgressBar();
		progressbar.setIndeterminate(true);
		dialog.getContentPane().add(progressbar);
		dialog.setSize(350, 60);
	}

	/**
	 * Hide window to unblock GUI and show window again with new content
	 */
	private void finish() {
		// Try to set location, but not working properly
		// TODO make it happen all the time
		Point loc = dialog.getLocation();
		int x = loc.x;
		int y = loc.y;
		dialog.setTitle(dialog.getTitle() + "dary!");
		dialog.setVisible(false);
		dialog.setModal(false);
		dialog.setLocation(x, y);
		dialog.setVisible(true);
	}

	/**
	 * Hide window
	 */
	public void destroy() {
		dialog.dispose();
	}

	/**
	 * Parse file and use progressbar. Notice: modal dialog blocks gui while
	 * parsing
	 * 
	 * @return true, if successful
	 */
	public boolean run() {
		Thread workerThread = new Thread(new Runnable() {
			public void run() {
				successful = inputParser.parse();
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						finish();
					}
				});
			}
		});
		workerThread.start();
		dialog.setLocationRelativeTo(GUI.getFrame());
		dialog.setVisible(true);
		return successful;
	}

}
