/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
 */

package comics.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class Statusbar extends JPanel {

	private static final long serialVersionUID = 1L;
	// Array der Felder, um spaeter auf diese zugreifen zu koennen
	private StatusbarField[] fields;

	public Statusbar(int numFields) {
		
		fields = new StatusbarField[numFields];

		// Der Einfachheit halber verwende ich hier
		// ein GridLayout. In der Praxis wuerde man
		// eventuell einen anderen LayoutManager
		// verwenden.
		setLayout(new GridLayout(1, numFields));

		// Hinzufuegen der Felder
		for (int i = 0; i < numFields; i++) {
			fields[i] = new StatusbarField();
			add(fields[i]);
		}
	}

	// Methode, um den Text eines Feldes zu aendern
	public void setText(int num, String text) {
		fields[num].setText(text);
	}

	// Methode, um den Text eines Feldes auszulesen
	public String getText(int num) {
		return fields[num].getText();
	}

	// Das eigentlich Feld: ein einfaches JLabel
	class StatusbarField extends JLabel {
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		public StatusbarField() {
			
			// Der Rand, der das Ganze wie eine typische
			// Statusleiste erscheinen laesst
			setBorder(new BevelBorder(BevelBorder.LOWERED));

			// Wichtiger als die Breite ist die Hoehe (hier: 18),
			// damit, ein leeres Feld genauso hoch ist wie eines
			// mit Text
			setPreferredSize(new Dimension(50, 18));

			// Font-Zuweisung, damit nicht die beim
			// Metal Look & Feel uebliche Fettschrift
			// verwendet wird
			setFont(new Font("Dialog", Font.PLAIN, 12));
		}
	}
}
