/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
*/

package comics.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;

import comics.graph.gui.GraphWrapper;
import comics.gui.EditMode;
import comics.gui.GUI;

public class GraphLayoutAction extends AbstractAction {

	private static final long serialVersionUID = 1L;
	private GraphWrapper.LayoutType layoutType;
	private GUI gui;

	public GraphLayoutAction(GUI gui, GraphWrapper wrapper, GraphWrapper.LayoutType layoutType) {
		this.gui = gui;
		this.layoutType = layoutType;

		switch (layoutType) {
		case FASTORGANIC:
			putValue(Action.NAME, "Fast Organic layout");
			break;
		case GRID:
			putValue(Action.NAME, "Grid");
			break;
		case TREE:
			putValue(Action.NAME, "Tree");
			break;
		case CIRCLE:
			putValue(Action.NAME, "Circle layout");
			break;
		case PARALLEL_EDGE:
			putValue(Action.NAME, "Parallel Edge layout");
			break;
		case PARTITION:
			putValue(Action.NAME, "Partition layout");
			break;
		case STACK:
			putValue(Action.NAME, "Stack layout");
			break;
		default:
			putValue(Action.NAME, "Hierarchical layout");
		}
		putValue(Action.DISPLAYED_MNEMONIC_INDEX_KEY, 1);
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		gui.wrapper.setEditMode(EditMode.NONE);
		gui.wrapper.setLayout(layoutType);
	}

}
