/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
 */

package comics.gui.actions;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

import com.mxgraph.model.mxCell;

import comics.SCC_MC;
import comics.graph.data.Edge;
import comics.graph.data.Node;
import comics.gui.EditMode;
import comics.gui.GUI;

public class GraphMouseListener extends MouseAdapter implements MouseWheelListener {

	Node src = null;

	private final int STATE_SRC = 1;
	private final int STATE_TRG = 2;
	private int state = STATE_SRC;

	// ----------------------------
	// Mouse Listener Methods
	// ----------------------------

	@Override
	public void mouseClicked(MouseEvent e) {
		GUI gui = SCC_MC.getInstance().getGui();

		Node selectedNode = gui.wrapper.getSelectedNode();
		Edge selectedEdge = gui.wrapper.getSelectedEdge();

		// Right-click -> context menu
		if (e.getModifiers() == 4) {
			if (selectedNode != null) {
				gui.getContextMenu().show(e, selectedNode);
			} else if (selectedEdge != null) {
				gui.getContextMenu().show(e, selectedEdge);
			}
		}

		// Add node or edge
		else if (gui.wrapper.getEditMode() == EditMode.ADD_NODE) {
			if (e.getModifiers() == 16) {
				if (gui.wrapper.getEditMode() == EditMode.ADD_NODE) {
					gui.wrapper.addNodeCell(e.getX() - 20, e.getY() - 20);
				}
			}
		} else if (gui.wrapper.getEditMode() == EditMode.ADD_EDGE) {
			if (gui.wrapper.isSelectionEmpty() || gui.wrapper.getSelectedNode() == null) {
				gui.setStatusBarMessage("No node selected");
				return;
			}

			if (e.getButton() == 1 && state == STATE_SRC) {
				src = gui.wrapper.getSelectedNode();
				if (src != null) {
					gui.setStatusBarMessage("Choose target node...");
					state = STATE_TRG;
				}
			} else if (state == STATE_TRG && e.getButton() == 1) {
				if (completeEdge()) {
					gui.setStatusBarMessage("Choose source node...");
					state = STATE_SRC;
				}
			}
		}

	}

	private boolean completeEdge() {
		GUI gui = SCC_MC.getInstance().getGui();
		Node targetNode = gui.wrapper.getSelectedNode();
		if (targetNode == null)
			return false;

		gui.wrapper.addEdgeCell(src.getGraphCell(), targetNode.getGraphCell());
		return true;
	}

	// ----------------------------
	// Mouse Wheel Listener Methods
	// ----------------------------
	@Override
	public void mouseWheelMoved(MouseWheelEvent e) {
		GUI gui = SCC_MC.getInstance().getGui();
		mxCell cell = null;
		int notches = e.getWheelRotation();
		if (notches > 0) {
			cell = gui.wrapper.getCellUnderMouse(e);
			gui.wrapper.rescaleByFactor(1d / 1.3);

		} else {
			cell = gui.wrapper.getCellUnderMouse(e);
			gui.wrapper.rescaleByFactor(1.3);
		}
		gui.wrapper.centerCell(cell);

	}

	public void resetState() {
		state = STATE_SRC;
	}
}
