/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
 */

package comics.gui.actions;

import java.awt.Color;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JColorChooser;

import comics.gui.EditMode;
import comics.gui.GUI;

public class NodeColorAction extends AbstractAction {

	private static final long serialVersionUID = 1L;
	public static final int DEFAULT_NODE = 0;
	public static final int INITIAL_NODE = 1;
	public static final int TARGET_NODE = 2;
	public static final int REDUCED_NODE = 3;
	private GUI gui;
	private int nodeType;

	public NodeColorAction(GUI gui, int nodeType) {
		this.gui = gui;
		this.nodeType = nodeType;

		switch (nodeType) {
		case INITIAL_NODE:
			putValue(Action.NAME, "Initial state");
			break;
		case TARGET_NODE:
			putValue(Action.NAME, "Target states");
			break;
		case REDUCED_NODE:
			putValue(Action.NAME, "Reduced states");
			break;
		default:
			putValue(Action.NAME, "Default states");
		}
		putValue(Action.DISPLAYED_MNEMONIC_INDEX_KEY, 0);
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		// TODO: Shouldn't always be red, but rather the current colors...
		Color c = JColorChooser.showDialog(GUI.getFrame(), "Choose a color", Color.red);

		switch (nodeType) {
		case INITIAL_NODE:
			gui.wrapper.setInitialNodeColor(c);
			break;
		case TARGET_NODE:
			gui.wrapper.setTargetNodeColor(c);
			break;
		case REDUCED_NODE:
			gui.wrapper.setReducedNodeColor(c);
			break;
		default:
			gui.wrapper.setDefaultNodeColor(c);
		}

		gui.wrapper.setEditMode(EditMode.NONE);
	}

}
