/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
 */

package comics.gui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import comics.SCC_MC;
import comics.gui.EditMode;
import comics.gui.GUI;
import comics.utilities.Output;

public class ToolMenuActionListener implements ActionListener {

	private SCC_MC scc_mc;
	private GUI gui;

	public ToolMenuActionListener(SCC_MC scc_mc, GUI gui) {
		this.scc_mc = scc_mc;
		this.gui = gui;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		if (e.getActionCommand().equals("search")) {
			gui.wrapper.setEditMode(EditMode.NONE);
			gui.popSearchMenu(!gui.wrapper.isGraphEmpty());
		} else if (e.getActionCommand().equals("hideIsolatedNodes")) {
			gui.wrapper.setEditMode(EditMode.NONE);
			gui.toggleHideIsolatedNodes();
		} else if (e.getActionCommand().equals("hideAbsorbingNodes")) {
			gui.wrapper.setEditMode(EditMode.NONE);
			gui.toggleHideAbsorbingNodes();
		} else if (e.getActionCommand().equals("centerInitial")) {
			gui.wrapper.centerInitial();
		} else if (e.getActionCommand().equals("checkConsistency")) {
			scc_mc.getMarkovChain().isMarkovChainConsistent();
		} else if (e.getActionCommand().equals("oneTarget")) {
			scc_mc.getMarkovChain().transformToOneTarget(gui.wrapper);
		} else if (e.getActionCommand().equals("chooseLabelTarget")) {
			scc_mc.chooseLabelTarget();
		} else if (e.getActionCommand().equals("chooseLabelInitial")) {
			scc_mc.chooseLabelInitial();
		} else {
			Output.print("Invalid action command (tool menu)");
			assert (false);
		}
	}
}
