/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
*/

package comics.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;

import comics.gui.EditMode;
import comics.gui.GUI;

public class ZoomRelativeAction extends AbstractAction {

	private static final long serialVersionUID = 1L;
	private boolean zoomIn;
	private GUI gui;

	public ZoomRelativeAction(GUI gui, boolean zoomIn) {
		this.gui = gui;
		this.zoomIn = zoomIn;
		
		putValue(Action.NAME, "Zoom " + (zoomIn ? "in" : "out"));
		putValue(Action.DISPLAYED_MNEMONIC_INDEX_KEY, 1);
		
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		
		if (zoomIn)
			gui.wrapper.rescaleByFactor(2d);
		else
			gui.wrapper.rescaleByFactor(0.5);

		gui.wrapper.setEditMode(EditMode.NONE);
	}

}
