/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
 */

package comics.gui.counterexample;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import comics.SCC_MC;
import comics.data.CounterExampleSearchParameters;
import comics.gui.GUI;

public class CounterExampleInitDialog {
	private ButtonGroup abstractButtonGroup = new ButtonGroup();
	private ButtonGroup globalButtonGroup = new ButtonGroup();
	private ButtonGroup closureButtonGroup = new ButtonGroup();
	private JRadioButton abstractButton;
	private JRadioButton concreteButton;
	private JRadioButton globalButton;
	private JRadioButton localButton;
	private JRadioButton closureButton;
	private JRadioButton pathsumButton;
	private JPanel abstractPanel = new JPanel();
	private JPanel abstractGroupPanel = new JPanel();
	private JPanel globalPanel = new JPanel();
	private JPanel globalGroupPanel = new JPanel();
	private JPanel closurePanel = new JPanel();
	private JPanel closureGroupPanel = new JPanel();

	/**
	 * Ask for counterexample Parameters
	 * 
	 * @param parameters
	 *            default parameters for this dialog from conf-file or general
	 *            default parameters
	 * @return false, if cancelled, true otherwise
	 */
	public boolean show(CounterExampleSearchParameters parameters) {
		// Abstract or concrete
		abstractGroupPanel.setLayout(new GridLayout(1, 2));
		JLabel abstractLabel = new JLabel("Abstract or concrete search algorithm?");

		abstractButton = new JRadioButton("Abstract");
		abstractButton.setActionCommand("abstract");
		abstractButtonGroup.add(abstractButton);
		abstractGroupPanel.add(abstractButton);

		concreteButton = new JRadioButton("Concrete");
		concreteButton.setActionCommand("concrete");
		abstractButtonGroup.add(concreteButton);
		abstractGroupPanel.add(concreteButton);

		if (parameters.isAbstractSearch()) {
			abstractButton.setSelected(true);
		} else {
			concreteButton.setSelected(true);
		}

		abstractPanel.setLayout(new GridLayout(2, 1));
		abstractPanel.add(abstractLabel);
		abstractPanel.add(abstractGroupPanel);

		// Global or local
		globalGroupPanel.setLayout(new GridLayout(1, 2));
		JLabel globalLabel = new JLabel("Global or local path search?");

		globalButton = new JRadioButton("Global");
		globalButton.setActionCommand("global");
		globalButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				closureGroupPanel.setEnabled(true);
				closurePanel.setEnabled(true);
				closureButton.setEnabled(true);
				pathsumButton.setEnabled(true);
			}
		});
		globalButtonGroup.add(globalButton);
		globalGroupPanel.add(globalButton);

		localButton = new JRadioButton("Local");
		localButton.setActionCommand("local");
		localButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				closureGroupPanel.setEnabled(false);
				closurePanel.setEnabled(false);
				closureButton.setEnabled(false);
				pathsumButton.setEnabled(false);
				closureButton.setSelected(true);
				SCC_MC.getInstance()
						.getGui()
						.setStatusBarMessage(
								"Can't use pathsum criterion for local search, because only path fragments are computed. Will use closures instead.");
			}
		});
		globalButtonGroup.add(localButton);
		globalGroupPanel.add(localButton);

		if (parameters.isGlobalSearch()) {
			globalButton.setSelected(true);
		} else {
			localButton.setSelected(true);
		}

		globalPanel.setLayout(new GridLayout(2, 1));
		globalPanel.add(globalLabel);
		globalPanel.add(globalGroupPanel);

		// Closure or pathsum
		closureGroupPanel.setLayout(new GridLayout(1, 2));
		JLabel closureLabel = new JLabel("Subsystem- or path-based counterexample?");

		closureButton = new JRadioButton("Subsystem");
		closureButton.setSelected(true);
		closureButton.setActionCommand("closure");
		closureButtonGroup.add(closureButton);
		closureGroupPanel.add(closureButton);

		pathsumButton = new JRadioButton("Pathset");
		pathsumButton.setActionCommand("pathsum");
		closureButtonGroup.add(pathsumButton);
		closureGroupPanel.add(pathsumButton);

		if (parameters.isClosure()) {
			closureButton.setSelected(true);
		} else {
			pathsumButton.setSelected(true);
		}

		closurePanel.setLayout(new GridLayout(2, 1));
		closurePanel.add(closureLabel);
		closurePanel.add(closureGroupPanel);

		Object[] content = { abstractPanel, globalPanel, closurePanel };
		JOptionPane contentPane = new JOptionPane(content, JOptionPane.QUESTION_MESSAGE, JOptionPane.OK_CANCEL_OPTION);
		JDialog dialog = contentPane.createDialog(GUI.getFrame(), "Choose Parameters for Counterexample");

		dialog.setVisible(true);
		// Dialog is closed, return value
		if (contentPane.getValue() == null || !contentPane.getValue().equals(JOptionPane.YES_OPTION)) {
			return false;
		} else {
			parameters.setAbstractSearch(abstractButton.isSelected());
			parameters.setGlobalSearch(globalButton.isSelected());
			parameters.setClosure(closureButton.isSelected());
			return true;
		}
	}
}
