/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
 */

package comics.gui.output_panel;

import javax.swing.*;
import java.util.*;

public class SortedListModel<T> extends AbstractListModel {
	private static final long serialVersionUID = 1L;

	// Define a SortedSet
	SortedSet<T> model;

	public SortedListModel() {
		// Create a TreeSet
		// Store it in SortedSet variable
		model = new TreeSet<T>();
	}

	// ListModel methods
	public int getSize() {
		// Return the model size
		return model.size();
	}

	@SuppressWarnings("unchecked")
	public T getElementAt(int index) {
		// Return the appropriate element
		return (T) model.toArray()[index];
	}

	// Other methods
	public void add(T element) {
		if (model.add(element)) {
			fireContentsChanged(this, 0, getSize());
		}
	}

	public void addAll(T elements[]) {
		Collection<T> c = Arrays.asList(elements);
		model.addAll(c);
		fireContentsChanged(this, 0, getSize());
	}

	public void clear() {
		model.clear();
		fireContentsChanged(this, 0, getSize());
	}

	public boolean contains(T element) {
		return model.contains(element);
	}

	public T firstElement() {
		// Return the appropriate element
		return model.first();
	}

	public Iterator<T> iterator() {
		return model.iterator();
	}

	public T lastElement() {
		// Return the appropriate element
		return model.last();
	}

	public boolean removeElement(T element) {
		boolean removed = model.remove(element);
		if (removed) {
			fireContentsChanged(this, 0, getSize());
		}
		return removed;
	}
}