/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
 */

package comics.gui.output_panel;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

import comics.SCC_MC;
import comics.graph.data.Node;

/**
 * Tab for nodes
 * 
 */
public class TabTargetNodes extends JScrollPane {
	private static final long serialVersionUID = 1L;
	private JList list;
	private SortedListModel<Node> listModel;
	private OverviewPanel overviewPanel;

	public TabTargetNodes(OverviewPanel overview) {
		setName("Targets");
		overviewPanel = overview;
		listModel = new SortedListModel<Node>();
		list = new JList(listModel);
		list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		list.setCellRenderer(new NodeRenderer());
		setViewportView(list);

		list.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent evt) {
				JList list = (JList) evt.getSource();
				// Detect double click
				if (evt.getClickCount() == 2) {
					// Get item index
					int index = list.locationToIndex(evt.getPoint());
					Node n = (Node) listModel.getElementAt(index);
					SCC_MC.getInstance().getGui().wrapper.centerNode(n);
				}
			}
		});
	}

	/**
	 * Clear list
	 * 
	 */
	public void clear() {
		listModel.clear();
	}

	/**
	 * Add new node to list
	 * 
	 * @param n
	 *            node
	 */
	public void addNode(Node n) {
		if (n.isTarget()) {
			listModel.add(n);
			overviewPanel.reloadValues();
		}
	}

	/**
	 * Change node in list
	 * 
	 * @param n
	 *            node
	 */
	public void changeNode(Node n) {
		if (n.isTarget()) {
			listModel.removeElement(n);
			listModel.add(n);
			overviewPanel.reloadValues();
		}
	}

	/**
	 * Remove node from list
	 * 
	 * @param n
	 *            node
	 */
	public void removeNode(Node n) {
		listModel.removeElement(n);
		overviewPanel.reloadValues();
	}

	/**
	 * Displays nodes as custom string
	 * 
	 */
	private class NodeRenderer extends DefaultListCellRenderer {
		private static final long serialVersionUID = 1L;

		public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected,
				boolean cellHasFocus) {
			super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
			Node n = (Node) value;
			String s = n.toString();
			String prob = n.propertyString();
			if (!prob.isEmpty()) {
				s += " (" + prob + ")";
			}
			setText(s);
			return this;
		}
	}
}