/**
 *   COMICS - Computing Minimal Counterexamples for Discrete-time Markov Chains
 *
 *   COMICS is a stand-alone tool which performs model checking and the generation
 *   of counterexamples for discrete-time Markov Chains (DTMCs). *
 *
 *   Copyright (C) <2012> <RWTH Aachen University>
 *   Authors: Nils Jansen, Erika Abraham, Jens Katelaan, Maik Scheffler, Matthias Volk, Andreas Vorpahl
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *   Main Contact:
 *
 *   Nils Jansen
 *   Theory of Hybrid Systems
 *   RWTH Aachen
 *   52056 Aachen
 *   Germany
 *   nils.jansen@cs.rwth-aachen.de
 *
*/

package comics.io;

import java.io.File;

import javax.swing.filechooser.FileFilter;

/**
 * Extension handling and file filter
 * 
 */
public class ExtensionFileFilter extends FileFilter {
	private String description;
	private ExtensionType[] extensions;

	/**
	 * Constructor
	 * 
	 * @param description
	 *            extension description
	 * @param extensions
	 *            file extensions
	 */
	public ExtensionFileFilter(String description, ExtensionType extensions[]) {
		if (description == null) {
			this.description = extensions[0].toString();
		} else {
			this.description = description;
		}
		this.extensions = extensions.clone();
	}

	public String getDescription() {
		return description;
	}

	public String getFirstExtension() {
		if (extensions == null)
			return "";
		else
			return extensions[0].toString();
	}

	public boolean accept(File file) {
		if (file.isDirectory()) {
			return true;
		} else {
			String path = file.getAbsolutePath().toLowerCase();
			for (int i = 0, n = extensions.length; i < n; i++) {
				String extension = extensions[i].toString();
				if ((path.endsWith(extension) && (path.charAt(path.length() - extension.length()
						- 1)) == '.')) {
					return true;
				}
			}
		}
		return false;
	}
}
